/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource.text;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kinugasa.game.GameLog;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.Input;
import kinugasa.resource.InputStatus;
import kinugasa.resource.Nameable;
import kinugasa.resource.Output;
import kinugasa.resource.OutputResult;
import kinugasa.resource.text.FileIOException;
import kinugasa.resource.text.FileNotFoundException;
import kinugasa.resource.text.IllegalXMLFormatException;
import kinugasa.resource.text.XMLElement;
import kinugasa.resource.text.XMLParserUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XMLFile
implements Input<XMLFile>,
Output,
Nameable,
Iterable<XMLElement> {
    private File file;
    private List<XMLElement> data;

    public XMLFile(File file) throws FileNotFoundException {
        this.file = file;
    }

    public XMLFile(String filePath) throws FileNotFoundException {
        this(new File(filePath));
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    private static DocumentBuilderFactory openBuilderFactory() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(true);
        builderFactory.setIgnoringComments(true);
        builderFactory.setIgnoringElementContentWhitespace(true);
        return builderFactory;
    }

    @Override
    public XMLFile load() throws IllegalXMLFormatException, FileNotFoundException, FileIOException {
        this.data = new ArrayList<XMLElement>();
        DocumentBuilderFactory builderFactory = XMLFile.openBuilderFactory();
        Document document = null;
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setErrorHandler(null);
            document = builder.parse(this.file);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IllegalXMLFormatException(ex);
        }
        catch (java.io.FileNotFoundException ex) {
            throw new FileNotFoundException(ex);
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        assert (document != null) : "document is null";
        this.data.add(XMLParserUtil.createElement(document.getLastChild()));
        GameLog.printInfoIfUsing("XMLFile [" + this.file.getName() + "] is loaded");
        return this;
    }

    @Override
    public void dispose() {
        this.data.clear();
        this.data = null;
    }

    @Override
    public InputStatus getStatus() {
        return this.data == null ? InputStatus.NOT_LOADED : InputStatus.LOADED;
    }

    @Override
    public OutputResult save() throws FileIOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OutputResult saveTo(File f) throws FileIOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public XMLFile add(XMLElement ... e) {
        this.data.addAll(Arrays.asList(e));
        return this;
    }

    public XMLFile remove(XMLElement ... e) {
        this.data.removeAll(Arrays.asList(e));
        return this;
    }

    public boolean contains(XMLElement e) {
        return this.data.contains(e);
    }

    public boolean contains(String e) {
        for (XMLElement xe : this.data) {
            if (!xe.getName().equals(e)) continue;
            return true;
        }
        return false;
    }

    public XMLElement getFirst() {
        return this.getStatus() == InputStatus.LOADED ? this.data.get(0) : null;
    }

    @Override
    public Iterator<XMLElement> iterator() {
        return this.data.iterator();
    }
}

