/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource.text;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import kinugasa.resource.Nameable;
import kinugasa.resource.text.XMLAttributeStorage;

public class XMLElement
implements Nameable {
    private String name;
    private Map<String, List<XMLElement>> content;
    private XMLAttributeStorage attributes;
    private String value;

    public XMLElement(String name, XMLAttributeStorage attributes, String value) {
        this.name = name;
        this.attributes = attributes;
        this.value = value;
    }

    public XMLElement(String name, Map<String, List<XMLElement>> content, XMLAttributeStorage attributes, String value) {
        this.name = name;
        this.content = content;
        this.attributes = attributes;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public XMLAttributeStorage getAttributes() {
        return this.attributes;
    }

    public Map<String, List<XMLElement>> getContent() {
        return this.content;
    }

    public List<XMLElement> getElement(String name) {
        return this.content.get(name);
    }

    public boolean hasElement(String name) {
        return this.content.containsKey(name);
    }

    public void printAll(PrintStream stream) {
        stream.println(this.name + " " + this.attributes);
        for (List<XMLElement> elements : this.content.values()) {
            for (XMLElement element : elements) {
                stream.println(element);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "XMLElement{" + this.name + " : " + this.attributes + " : " + this.value + "}";
    }
}

