/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource.text;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kinugasa.resource.Input;
import kinugasa.resource.InputStatus;
import kinugasa.resource.Nameable;
import kinugasa.resource.Output;
import kinugasa.resource.OutputResult;
import kinugasa.resource.text.FileIOException;

public class TextFile
implements Input<TextFile>,
Output,
Nameable,
Iterable<String> {
    private File file;
    private Charset charset;
    private List<String> data;

    public TextFile(File file) {
        this.file = file;
        this.charset = Charset.forName("MS932");
    }

    public TextFile(String path) {
        this.file = new File(path);
        this.charset = Charset.forName("MS932");
    }

    public TextFile(File file, Charset c) {
        this.file = file;
        this.charset = c;
    }

    public TextFile(String path, Charset c) {
        this.file = new File(path);
        this.charset = c;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public List<String> getData() {
        return this.data;
    }

    @Override
    public Iterator<String> iterator() {
        return this.data.iterator();
    }

    @Override
    public TextFile load() throws FileIOException {
        this.data = new ArrayList<String>();
        try {
            for (String line : Files.readAllLines(this.file.toPath(), this.charset)) {
                this.data.add(line);
            }
        }
        catch (IOException ex) {
            throw new FileIOException(ex);
        }
        return this;
    }

    @Override
    public void dispose() {
        this.data.clear();
        this.data = null;
    }

    @Override
    public InputStatus getStatus() {
        return this.data == null ? InputStatus.NOT_LOADED : InputStatus.LOADED;
    }

    @Override
    public OutputResult save() throws FileIOException {
        return this.saveTo(this.file);
    }

    @Override
    public OutputResult saveTo(File f) throws FileIOException {
        try {
            Files.write(f.toPath(), this.data, this.charset, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            throw new FileIOException(ex);
        }
        return OutputResult.OK;
    }
}

