/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object.movemodel;

import kinugasa.object.BasicSprite;
import kinugasa.object.MovingModel;

public class SpeedChange
extends MovingModel {
    private float addSpeed;
    private float minSpeed;
    private float maxSpeed;

    public SpeedChange(float addSpeed, float min, float max) throws IllegalArgumentException {
        if (min > max) {
            throw new IllegalArgumentException("! > min > max ! min=[" + min + "] max=[" + max + "]");
        }
        this.addSpeed = addSpeed;
        this.minSpeed = min;
        this.maxSpeed = max;
    }

    public SpeedChange(float addSpeed) {
        this(addSpeed, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    }

    public float getAddSpeed() {
        return this.addSpeed;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public float getMinSpeed() {
        return this.minSpeed;
    }

    public void setAddSpeed(float addSpeed) {
        this.addSpeed = addSpeed;
    }

    public void setMaxSpeed(float maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public void setMinSpeed(float minSpeed) {
        this.minSpeed = minSpeed;
    }

    @Override
    public void move(BasicSprite s) {
        s.setSpeed(s.getSpeed() + this.addSpeed);
        if (s.getSpeed() < this.minSpeed) {
            s.setSpeed(this.minSpeed);
        }
        if (s.getSpeed() > this.maxSpeed) {
            s.setSpeed(this.maxSpeed);
        }
    }

    @Override
    public SpeedChange clone() {
        return (SpeedChange)super.clone();
    }
}

