/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RasterFormatException;
import java.util.Arrays;
import kinugasa.graphics.ARGBColor;
import kinugasa.graphics.ImageUtil;
import kinugasa.graphics.RenderingQuality;

public final class ImageEditor {
    private ImageEditor() {
    }

    public static BufferedImage replaceColor(BufferedImage src, int tgtARGB, int newARGB, BufferedImage dst) {
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] pix = ImageUtil.getPixel(src);
        for (int i = 0; i < pix.length; ++i) {
            if (pix[i] != tgtARGB) continue;
            pix[i] = newARGB;
        }
        ImageUtil.setPixel(dst, pix);
        return dst;
    }

    public static BufferedImage grayScale(BufferedImage src, BufferedImage dst) {
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] pix = ImageUtil.getPixel(src);
        for (int i = 0; i < pix.length; ++i) {
            int average = ARGBColor.getRGBAverage(pix[i]);
            pix[i] = pix[i] & 0xFF000000 | average << 16 | average << 8 | average;
        }
        ImageUtil.setPixel(dst, pix);
        return dst;
    }

    public static BufferedImage weightedGrayScale(BufferedImage src, BufferedImage dst) {
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] pix = ImageUtil.getPixel(src);
        for (int i = 0; i < pix.length; ++i) {
            int brightness = (int)((float)ARGBColor.getRed(pix[i]) * 0.298912f) + (int)((float)ARGBColor.getGreen(pix[i]) * 0.586611f) + (int)((float)ARGBColor.getBlue(pix[i]) * 0.114478f);
            pix[i] = pix[i] & 0xFF000000 | brightness << 16 | brightness << 8 | brightness;
        }
        ImageUtil.setPixel(dst, pix);
        return dst;
    }

    public static BufferedImage monochrome(BufferedImage src, int center, BufferedImage dst) throws IllegalArgumentException {
        if (center < 0 || center > 255) {
            throw new IllegalArgumentException("center is over color range : center=[" + center + "]");
        }
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] pix = ImageUtil.getPixel(src);
        for (int i = 0; i < pix.length; ++i) {
            pix[i] = ARGBColor.getRGBAverage(pix[i]) > center ? pix[i] & 0xFF000000 | 0xFFFFFF : pix[i] & 0xFF000000;
        }
        ImageUtil.setPixel(dst, pix);
        return dst;
    }

    public static BufferedImage brightness(BufferedImage src, float right, BufferedImage dst) throws IllegalArgumentException {
        if (right == 1.0f) {
            dst = ImageUtil.copy(src);
            return dst;
        }
        if (right < 0.0f) {
            throw new IllegalArgumentException("right < 0 : right=[" + right + "]");
        }
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] pix = ImageUtil.getPixel(src);
        for (int i = 0; i < pix.length; ++i) {
            int a = ARGBColor.getAlpha(pix[i]);
            int r = (int)((float)ARGBColor.getRed(pix[i]) * right);
            if (r > 255) {
                r = 255;
            } else if (r < 0) {
                r = 0;
            }
            int g = (int)((float)ARGBColor.getGreen(pix[i]) * right);
            if (g > 255) {
                g = 255;
            } else if (g < 0) {
                g = 0;
            }
            int b = (int)((float)ARGBColor.getBlue(pix[i]) * right);
            if (b > 255) {
                b = 255;
            } else if (b < 0) {
                b = 0;
            }
            pix[i] = ARGBColor.toARGB(a, r, g, b);
        }
        ImageUtil.setPixel(dst, pix);
        return dst;
    }

    public static BufferedImage reverseColor(BufferedImage src, BufferedImage dst) {
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] pix = ImageUtil.getPixel(src);
        for (int i = 0; i < pix.length; ++i) {
            int a = pix[i] & 0xFF000000;
            int r = 255 - ARGBColor.getRed(pix[i]) << 16;
            int g = 255 - ARGBColor.getGreen(pix[i]) << 8;
            int b = ARGBColor.getBlue(pix[i]);
            pix[i] = ARGBColor.toARGB(a, r, g, b);
        }
        ImageUtil.setPixel(dst, pix);
        return dst;
    }

    public static BufferedImage mosaic(BufferedImage src, int size, BufferedImage dst) throws IllegalArgumentException, RasterFormatException {
        if (size < 1) {
            throw new IllegalArgumentException("size < 1 : size=[" + size + "]");
        }
        if (size > src.getWidth() || size > src.getHeight()) {
            throw new RasterFormatException("size is over image bounds : size=[" + size + "]");
        }
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[][] pix = ImageUtil.getPixel2D(src);
        int y = 0;
        int imageHeight = src.getHeight();
        while (y + size < imageHeight) {
            int x = 0;
            int imageWidth = src.getWidth();
            while (x + size < imageWidth) {
                int argb = pix[y][x];
                int mosaicY = y;
                for (int i = 0; i < size; ++i) {
                    int mosaicX = x;
                    for (int j = 0; j < size; ++j) {
                        if (mosaicX <= imageWidth && mosaicY <= imageHeight) {
                            pix[mosaicY][mosaicX] = argb;
                        }
                        ++mosaicX;
                    }
                    ++mosaicY;
                }
                x += size;
            }
            y += size;
        }
        ImageUtil.setPixel2D(dst, pix);
        return dst;
    }

    public static BufferedImage rotate(BufferedImage src, float deg, BufferedImage dst) {
        if (deg == 0.0f) {
            dst = ImageUtil.copy(src);
            return dst;
        }
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        Graphics2D g = ImageUtil.createGraphics2D(dst, RenderingQuality.QUALITY);
        g.setClip(0, 0, dst.getWidth(), dst.getHeight());
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, dst.getWidth(), dst.getHeight());
        g.rotate(Math.toRadians(deg), dst.getWidth() / 2, dst.getHeight() / 2);
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return dst;
    }

    public static BufferedImage addTransparent(BufferedImage src, int tp, BufferedImage dst) {
        if (tp == 0) {
            dst = ImageUtil.copy(src);
            return dst;
        }
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] pix = ImageUtil.getPixel(src);
        for (int i = 0; i < pix.length; ++i) {
            int alpha = ARGBColor.getAlpha(pix[i]);
            if ((alpha += tp) < 0) {
                alpha = 0;
            } else if (alpha > 255) {
                alpha = 255;
            }
            pix[i] = alpha << 24 & 0xFF000000 | pix[i] & 0xFFFFFF;
        }
        ImageUtil.setPixel(dst, pix);
        return dst;
    }

    public static BufferedImage rasterScroll(BufferedImage src, BufferedImage dst, int[] shiftPixNum, int insertARGB) {
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] sPix = shiftPixNum;
        if (shiftPixNum.length != dst.getHeight()) {
            sPix = new int[dst.getHeight()];
            int spi = 0;
            for (int i = 0; i < sPix.length; ++i) {
                sPix[i] = shiftPixNum[spi];
                spi = spi < shiftPixNum.length - 1 ? spi + 1 : 0;
            }
        }
        int[][] pix = ImageUtil.getPixel2D(dst);
        for (int y = 0; y < pix.length; ++y) {
            if (sPix[y] == 0) continue;
            int[] ROW = new int[pix[y].length];
            System.arraycopy(pix[y], 0, ROW, 0, ROW.length);
            int x = 0;
            int lineIdx = 0;
            if (sPix[y] > 0) {
                Arrays.fill(pix[y], 0, sPix[y], insertARGB);
                x += sPix[y];
            } else {
                lineIdx += Math.abs(sPix[y]);
            }
            System.arraycopy(ROW, lineIdx, pix[y], x, ROW.length - Math.abs(sPix[y]));
            Arrays.fill(pix[y], x += ROW.length - Math.abs(sPix[y]), pix[y].length, insertARGB);
        }
        ImageUtil.setPixel2D(dst, pix);
        return dst;
    }

    public static BufferedImage blur2D(BufferedImage src, int width, int height, BufferedImage dst) {
        return ImageEditor.blur(ImageEditor.blur(src, width, false, dst), height, true, null);
    }

    public static BufferedImage blur(BufferedImage src, int rad, boolean hrz, BufferedImage dst) throws IllegalArgumentException {
        int i;
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        if (rad < 1) {
            throw new IllegalArgumentException("radius < 1 :  rad=[" + rad + "]");
        }
        int size = rad * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)rad * 3.0f;
        float twoSigmaSq = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSq * Math.PI);
        float total = 0.0f;
        for (i = -rad; i < rad; ++i) {
            float dist = i * i;
            int index = i + rad;
            data[index] = (float)Math.exp(-dist / twoSigmaSq) / sigmaRoot;
            total += data[index];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = hrz ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        ConvolveOp op = new ConvolveOp(kernel, 1, null);
        return op.filter(src, dst);
    }

    public static BufferedImage transparent(BufferedImage src, float tp, BufferedImage dst) throws IllegalArgumentException {
        if (tp > 1.0f || tp < 0.0f) {
            throw new IllegalArgumentException("\u900f\u904e\u5024\u304c\u7121\u52b9\u3067\u3059 [tp > 1 || tp < 0]\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059 tp=[" + tp + "]");
        }
        if (dst == null || dst == src) {
            dst = ImageUtil.copy(src);
        }
        int[] pix = ImageUtil.getPixel(src);
        int alpha = (int)(255.0f * tp) << 24;
        for (int i = 0; i < pix.length; ++i) {
            pix[i] = (pix[i] & 0xFF000000) != 0 ? alpha | pix[i] & 0xFFFFFF : pix[i] & 0xFFFFFF;
        }
        ImageUtil.setPixel(dst, pix);
        return dst;
    }

    public static BufferedImage resize(BufferedImage src, float scale) {
        if (Float.compare(scale, 1.0f) == 0) {
            return ImageUtil.copy(src);
        }
        int newWidth = (int)((float)src.getWidth() * scale);
        int newHeight = (int)((float)src.getHeight() * scale);
        BufferedImage dst = ImageUtil.newImage(newWidth, newHeight);
        Graphics2D g2 = ImageUtil.createGraphics2D(dst, RenderingQuality.SPEED);
        g2.drawImage(src, 0, 0, newWidth, newHeight, null);
        g2.dispose();
        return dst;
    }

    public static BufferedImage[] resizeAll(BufferedImage[] images, float scale) {
        BufferedImage[] result = new BufferedImage[images.length];
        for (int i = 0; i < result.length; ++i) {
            if (images[i] == null) continue;
            result[i] = ImageEditor.resize(images[i], scale);
        }
        return result;
    }
}

