/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.graphics;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import kinugasa.game.GameLog;
import kinugasa.game.GraphicsContext;
import kinugasa.graphics.TColorException;

public class GraphicsUtil {
    public static Color createColor(List<String> rgba) throws TColorException {
        if (rgba.isEmpty() || rgba.size() <= 2 || rgba.size() >= 5) {
            throw new TColorException(rgba);
        }
        int r = Integer.parseInt(rgba.get(0));
        int g = Integer.parseInt(rgba.get(1));
        int b = Integer.parseInt(rgba.get(2));
        int a = rgba.size() <= 3 ? 255 : Integer.parseInt(rgba.get(3));
        return new Color(r, g, b, a);
    }

    public static Color createColor(String[] rgba) throws TColorException {
        return GraphicsUtil.createColor(Arrays.asList(rgba));
    }

    private GraphicsUtil() {
    }

    public static void useOpenGL() {
        System.setProperty("sun.java2d.opengl", "true");
        GameLog.printInfoIfUsing("> opengl state : [" + System.getProperty("sun.java2d.opengl") + "]");
    }

    public static boolean isUseOpenGL() {
        return System.getProperty("sun.java2d.opengl").equals("true");
    }

    public static void clearRect(GraphicsContext g, Rectangle2D r) {
        g.clearRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static void drawRect(GraphicsContext g, Rectangle2D r) {
        g.drawRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static void fillRect(GraphicsContext g, Rectangle2D r) {
        g.fillRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static void drawOval(GraphicsContext g, Rectangle2D r) {
        g.drawOval((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static void fillOval(GraphicsContext g, Rectangle2D r) {
        g.fillOval((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }
}

