/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.graphics;

import kinugasa.graphics.ColorTransitionModel;

public class FadeCounter
extends ColorTransitionModel {
    private static final long serialVersionUID = -1609450992263652227L;
    private int speed;
    private boolean started = false;
    private boolean ended = false;

    public FadeCounter(int value, int speed) throws IllegalArgumentException {
        super(value);
        this.speed = speed;
    }

    public static FadeCounter fadeIn(int speed) {
        return new FadeCounter(0, speed);
    }

    public static FadeCounter fadeOut(int speed) {
        return new FadeCounter(255, speed);
    }

    @Override
    public void update() {
        if (this.ended) {
            return;
        }
        this.started = true;
        this.value += this.speed;
        if (this.value < 0) {
            this.value = 0;
            this.ended = true;
        } else if (this.value > 255) {
            this.value = 255;
            this.ended = true;
        }
    }

    @Override
    public boolean isRunning() {
        return this.started;
    }

    @Override
    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public String toString() {
        return "ColorFadeCounter{value=" + this.value + ", speed=" + this.speed + "}";
    }

    @Override
    public FadeCounter clone() {
        return (FadeCounter)super.clone();
    }
}

