/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.graphics;

import java.awt.Color;

public final class ARGBColor {
    public static final int ARGB_ALPHA_MASK = -16777216;
    public static final int ARGB_RED_MASK = 0xFF0000;
    public static final int ARGB_GREEN_MASK = 65280;
    public static final int ARGB_BLUE_MASK = 255;
    public static final int ALPHA_OPAQUE = 255;
    public static final int ALPHA_TRANSPARENT = 0;
    public static final int CLEAR_BLACK = 0;
    public static final int CLEAR_WHITE = 0xFFFFFF;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int LIGHTGRAY = -4144960;
    public static final int GRAY = -8355712;
    public static final int DARKGRAY = -12566464;
    public static final int ORANGE = -14336;
    public static final int YELLOW = -256;
    public static final int MAGENTA = -65281;
    public static final int CYAN = -16711681;

    private ARGBColor() {
    }

    private static void checkColor(int a, int r, int g, int b) throws IllegalArgumentException {
        Object badComp = "";
        if (a < 0 || a > 255) {
            badComp = (String)badComp + " A";
        }
        if (r < 0 || r > 255) {
            badComp = (String)badComp + " R";
        }
        if (g < 0 || g > 255) {
            badComp = (String)badComp + " G";
        }
        if (b < 0 || b > 255) {
            badComp = (String)badComp + " B";
        }
        if (!"".equals(badComp)) {
            throw new IllegalArgumentException("out of range : " + (String)badComp);
        }
    }

    public static boolean checkRange(int a, int r, int g, int b) {
        try {
            ARGBColor.checkColor(a, r, g, b);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static int toARGB(int r, int g, int b) throws IllegalArgumentException {
        ARGBColor.checkColor(255, r, g, b);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int toARGB(int a, int r, int g, int b) {
        ARGBColor.checkColor(a, r, g, b);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int toARGB(Color c) {
        return c.getRGB();
    }

    public static Color toAWTColor(int argb) {
        return new Color(ARGBColor.getRed(argb), ARGBColor.getGreen(argb), ARGBColor.getBlue(argb), ARGBColor.getAlpha(argb));
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static boolean isTransparent(int argb) {
        return ARGBColor.getAlpha(argb) == 0;
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int getRGBAverage(int argb) {
        return (ARGBColor.getRed(argb) + ARGBColor.getGreen(argb) + ARGBColor.getBlue(argb)) / 3;
    }

    public static String toString(int argb) {
        return "ARGB:[" + ARGBColor.getAlpha(argb) + ", " + ARGBColor.getRed(argb) + ", " + ARGBColor.getGreen(argb) + ", " + ARGBColor.getBlue(argb) + "]";
    }
}

