/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.ui;

import java.awt.Color;
import java.awt.Font;
import kinugasa.game.ui.FontModelStorage;
import kinugasa.object.Model;
import kinugasa.resource.Nameable;

public class FontModel
extends Model
implements Nameable {
    public static final FontModel DEFAULT = new FontModel("DEFAULT", Color.WHITE, new Font("MONOSPACED", 0, 18));
    private Color color;
    private Font font;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    public FontModel(String name, Color color, Font font) {
        this.name = name;
        this.color = color;
        this.font = font;
        this.addThis();
    }

    private void addThis() {
        FontModelStorage.getInstance().add(this);
    }

    public Color getColor() {
        return this.color;
    }

    public FontModel setColor(Color color) {
        this.color = color;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public FontModel setFont(Font font) {
        this.font = font;
        return this;
    }

    public FontModel setFontSize(float size) {
        this.font = this.font.deriveFont(size);
        return this;
    }

    public FontModel setFontStyle(int style) {
        this.font = this.font.deriveFont(style);
        return this;
    }

    @Override
    public FontModel clone() {
        return (FontModel)super.clone();
    }
}

