/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kinugasa.game.GameLog;
import kinugasa.game.rpgui.ChipAttribute;
import kinugasa.game.rpgui.ChipAttributeStorage;
import kinugasa.game.rpgui.Vehicle;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.NameNotFoundException;
import kinugasa.resource.Storage;
import kinugasa.resource.text.FileNotFoundException;
import kinugasa.resource.text.IllegalXMLFormatException;
import kinugasa.resource.text.XMLAttribute;
import kinugasa.resource.text.XMLElement;
import kinugasa.resource.text.XMLFile;
import kinugasa.resource.text.XMLFileSupport;
import kinugasa.util.StopWatch;

public class VehicleStorage
extends Storage<Vehicle>
implements Serializable,
XMLFileSupport {
    private static final long serialVersionUID = -8199049449459770547L;
    private static final VehicleStorage INSTANCE = new VehicleStorage();
    private Vehicle currentVehicle;

    private VehicleStorage() {
    }

    public static VehicleStorage getInstance() {
        return INSTANCE;
    }

    public Vehicle getCurrentVehicle() {
        return this.currentVehicle;
    }

    public void setCurrentVehicle(Vehicle currentVehicle) {
        this.currentVehicle = currentVehicle;
    }

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, FileNotFoundException, ContentsIOException, NameNotFoundException {
        StopWatch watch = new StopWatch().start();
        XMLFile reader = new XMLFile(filePath).load();
        XMLElement root = reader.getFirst();
        if (!"kinugasaVehicle".equals(root.getName())) {
            throw new IllegalXMLFormatException("illegal root node name : " + root);
        }
        List<XMLElement> vehiclesElement = root.getElement("vehicle");
        int size = vehiclesElement.size();
        for (int i = 0; i < size; ++i) {
            XMLElement vehicle = vehiclesElement.get(i);
            String name = ((XMLAttribute)vehicle.getAttributes().get("name")).getValue();
            float speed = ((XMLAttribute)vehicle.getAttributes().get("speed")).getFloatValue();
            List<XMLElement> chipAttribute = vehicle.getElement("stepOn");
            ArrayList<ChipAttribute> stepOnAttributes = new ArrayList<ChipAttribute>(chipAttribute.size());
            ChipAttributeStorage storage = ChipAttributeStorage.getInstance();
            int attributeSize = chipAttribute.size();
            for (int j = 0; j < attributeSize; ++j) {
                stepOnAttributes.add((ChipAttribute)storage.get(((XMLAttribute)chipAttribute.get(j).getAttributes().get("attribute")).getValue()));
            }
            new Vehicle(name, speed, stepOnAttributes);
        }
        reader.dispose();
        watch.stop();
        GameLog.printInfo("\u30d3\u30fc\u30af\u30eb\u304c\u6b63\u5e38\u306b\u8aad\u307f\u8fbc\u307e\u308c\u307e\u3057\u305f(" + watch.getTime() + " ms) : size=[" + this.size() + "]");
        ArrayList list = new ArrayList(this.getAll());
        Collections.sort(list);
        int size2 = list.size();
        for (int i = 0; i < size2; ++i) {
            GameLog.printInfo("- " + ((Vehicle)list.get(i)).getName());
            List<ChipAttribute> st = ((Vehicle)list.get(i)).getAttributeStorage().asList();
            int vSize = st.size();
            for (int j = 0; j < vSize; ++j) {
                GameLog.printInfo("-- " + st.get(j));
            }
        }
    }
}

