/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kinugasa.game.rpgui.ChipAttributeStorage;
import kinugasa.game.rpgui.ChipSetStorage;
import kinugasa.game.rpgui.FieldMapBuilderStorage;
import kinugasa.game.rpgui.VehicleStorage;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.DuplicateNameException;
import kinugasa.resource.text.FileNotFoundException;
import kinugasa.resource.text.IllegalXMLFormatException;

public final class FieldMapLoader {
    private List<String> attributeFileList = new ArrayList<String>();
    private List<String> vehicleFileList = new ArrayList<String>();
    private List<String> chipSetFileList = new ArrayList<String>();
    private List<String> fieldMapBuiderFileList = new ArrayList<String>();

    public FieldMapLoader attribute(String filePath) {
        this.attributeFileList.add(filePath);
        return this;
    }

    public FieldMapLoader vehicle(String filePath) {
        this.vehicleFileList.add(filePath);
        return this;
    }

    public FieldMapLoader chipSet(String filePath) {
        this.chipSetFileList.add(filePath);
        return this;
    }

    public FieldMapLoader fieldMapBuilder(String filePath) {
        this.fieldMapBuiderFileList.add(filePath);
        return this;
    }

    public void load() throws IllegalXMLFormatException, FileNotFoundException, ContentsIOException, NumberFormatException, DuplicateNameException {
        this.load(null);
    }

    public void load(PrintStream stream) throws IllegalXMLFormatException, FileNotFoundException, ContentsIOException, NumberFormatException, DuplicateNameException {
        int i;
        int size = this.attributeFileList.size();
        for (i = 0; i < size; ++i) {
            ChipAttributeStorage.getInstance().readFromXML(this.attributeFileList.get(i));
        }
        size = this.vehicleFileList.size();
        for (i = 0; i < size; ++i) {
            VehicleStorage.getInstance().readFromXML(this.vehicleFileList.get(i));
        }
        size = this.chipSetFileList.size();
        for (i = 0; i < size; ++i) {
            ChipSetStorage.getInstance().readFromXML(this.chipSetFileList.get(i));
        }
        size = this.fieldMapBuiderFileList.size();
        for (i = 0; i < size; ++i) {
            FieldMapBuilderStorage.getInstance().readFromXML(this.fieldMapBuiderFileList.get(i));
        }
        if (stream != null) {
            ChipAttributeStorage.getInstance().printAll(stream, true);
            VehicleStorage.getInstance().printAll(stream, true);
            ChipSetStorage.getInstance().printAll(stream, true);
            FieldMapBuilderStorage.getInstance().printAll(stream, true);
            stream.println("> " + FieldMapBuilderStorage.getInstance());
        }
    }

    public String toString() {
        return "FieldMapLoader{attributeFileList=" + this.attributeFileList + ", vehicleFileList=" + this.vehicleFileList + ", chipSetFileList=" + this.chipSetFileList + "}";
    }
}

