/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import kinugasa.game.GameLog;
import kinugasa.game.rpgui.ChipAttribute;
import kinugasa.game.rpgui.ChipAttributeStorage;
import kinugasa.game.rpgui.ChipSet;
import kinugasa.game.rpgui.MapChip;
import kinugasa.graphics.ImageUtil;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.NameNotFoundException;
import kinugasa.resource.Storage;
import kinugasa.resource.TImage;
import kinugasa.resource.text.FileNotFoundException;
import kinugasa.resource.text.IllegalXMLFormatException;
import kinugasa.resource.text.XMLAttribute;
import kinugasa.resource.text.XMLElement;
import kinugasa.resource.text.XMLFile;
import kinugasa.resource.text.XMLFileSupport;
import kinugasa.util.StopWatch;

public class ChipSetStorage
extends Storage<ChipSet>
implements XMLFileSupport {
    private static final ChipSetStorage INSTANCE = new ChipSetStorage();

    private ChipSetStorage() {
    }

    public static ChipSetStorage getInstance() {
        return INSTANCE;
    }

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, FileNotFoundException, ContentsIOException, NumberFormatException, NameNotFoundException {
        StopWatch watch = new StopWatch().start();
        XMLFile reader = new XMLFile(filePath).load();
        XMLElement root = reader.getFirst();
        if (!"kinugasaChipSet".equals(root.getName())) {
            throw new IllegalXMLFormatException("illegal root node name :" + root);
        }
        List<XMLElement> chipSetElementList = root.getElement("chipSet");
        int chipSetSize = chipSetElementList.size();
        for (int i = 0; i < chipSetSize; ++i) {
            XMLElement chipSetElement = chipSetElementList.get(i);
            int cutWidth = ((XMLAttribute)chipSetElement.getAttributes().get("cutWidth")).getIntValue();
            int cutHeight = ((XMLAttribute)chipSetElement.getAttributes().get("cutHeight")).getIntValue();
            ChipSet chipSet = new ChipSet(((XMLAttribute)chipSetElement.getAttributes().get("name")).getValue(), cutWidth, cutHeight);
            Map<String, BufferedImage> imageMap = ImageUtil.splitAsMapN(ImageUtil.load(((XMLAttribute)chipSetElement.getAttributes().get("image")).getValue()), cutWidth, cutHeight, 3);
            List<XMLElement> mapChipElementList = chipSetElement.getElement("mapChip");
            int mapChipSize = mapChipElementList.size();
            for (int j = 0; j < mapChipSize; ++j) {
                XMLElement mapChipElement = mapChipElementList.get(j);
                String mapChipName = ((XMLAttribute)mapChipElement.getAttributes().get("name")).getValue();
                ChipAttribute attribute = (ChipAttribute)ChipAttributeStorage.getInstance().get(((XMLAttribute)mapChipElement.getAttributes().get("attribute")).getValue());
                chipSet.add(new MapChip(mapChipName, imageMap.get(mapChipName) == null ? new TImage(ImageUtil.newImage(1, 1)) : new TImage(imageMap.get(mapChipName)), attribute));
            }
        }
        reader.dispose();
        watch.stop();
        GameLog.printInfo("\u30c1\u30c3\u30d7\u30bb\u30c3\u30c8\u304c\u6b63\u5e38\u306b\u8aad\u307f\u8fbc\u307e\u308c\u307e\u3057\u305f(" + watch.getTime() + " ms) : size=[" + this.size() + "]");
    }
}

