/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.awt.image.BufferedImage;
import kinugasa.game.GraphicsContext;
import kinugasa.graphics.Animation;
import kinugasa.graphics.ImageUtil;
import kinugasa.object.AnimationSprite;
import kinugasa.object.TVector;
import kinugasa.resource.Disposable;
import kinugasa.util.TimeCounter;

public class BackgroundLayerSprite
extends AnimationSprite
implements Disposable {
    private static final long serialVersionUID = -7754463251969957979L;

    public BackgroundLayerSprite(float speed, int x, int y, int width, int height, int drawWidth, int drawHeight, TimeCounter tc, BufferedImage ... images) {
        super((float)x, (float)y, width, height);
        this.setVector(new TVector(speed));
        BufferedImage[] buildeImage = new BufferedImage[images.length];
        for (int i = 0; i < images.length; ++i) {
            buildeImage[i] = ImageUtil.tiling(images[i], null, (int)(this.getWidth() / (float)images[i].getWidth()), (int)(this.getHeight() / (float)images[i].getHeight()), drawWidth, drawHeight);
        }
        this.setAnimation(new Animation(tc, buildeImage));
    }

    @Override
    public void draw(GraphicsContext g) {
        float dx;
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        float dy = this.getY();
        for (dx = this.getX(); dx >= 0.0f; dx -= this.getWidth()) {
        }
        while (dy >= 0.0f) {
            dy -= this.getHeight();
        }
        float idx = dx;
        BufferedImage image = this.getAnimation().getCurrentBImage();
        float totalHeight = -dy + this.getHeight();
        float totalWidth = -dx + this.getWidth();
        while (dy < totalHeight) {
            while (dx < totalWidth) {
                g.drawImage(image, (int)dx, (int)dy);
                dx += (float)image.getWidth(null);
            }
            dx = idx;
            dy += (float)image.getHeight(null);
        }
        if (super.isImageUpdate()) {
            super.update();
        }
    }

    @Override
    public void dispose() {
        this.setAnimation(null);
    }
}

