/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.input;

import javax.swing.ImageIcon;
import kinugasa.game.GraphicsContext;
import kinugasa.game.input.ButtonSprite;
import kinugasa.game.input.GamePadState;
import kinugasa.game.input.StickSprite;
import kinugasa.game.input.TrrigerSprite;
import kinugasa.object.BasicSprite;

public class GamePadStatusMonitor
extends BasicSprite {
    private ImageIcon image = new ImageIcon(this.getClass().getResource("gamepad.png"));
    private GamePadState gs;
    private ButtonSprite A = new ButtonSprite("A", 464.0f, 210.0f, 20);
    private ButtonSprite B = new ButtonSprite("B", 484.0f, 180.0f, 20);
    private ButtonSprite X = new ButtonSprite("X", 444.0f, 180.0f, 20);
    private ButtonSprite Y = new ButtonSprite("Y", 464.0f, 150.0f, 20);
    private ButtonSprite RB = new ButtonSprite("RB", 464.0f, 110.0f, 36);
    private ButtonSprite LB = new ButtonSprite("LB", 124.0f, 110.0f, 36);
    private ButtonSprite RS = new ButtonSprite("RS", 164.0f, 160.0f, 36);
    private ButtonSprite LS = new ButtonSprite("LS", 380.0f, 260.0f, 36);
    private ButtonSprite L = new ButtonSprite("<", 194.0f, 270.0f, 20);
    private ButtonSprite R = new ButtonSprite(">", 244.0f, 270.0f, 20);
    private ButtonSprite U = new ButtonSprite("^", 218.0f, 250.0f, 20);
    private ButtonSprite D = new ButtonSprite("v", 218.0f, 290.0f, 20);
    private ButtonSprite BACK = new ButtonSprite("Ba", 238.0f, 160.0f, 36);
    private ButtonSprite START = new ButtonSprite("St", 368.0f, 160.0f, 36);
    private TrrigerSprite LT = new TrrigerSprite("LT", 85.0f, 75.0f);
    private TrrigerSprite RT = new TrrigerSprite("RT", 430.0f, 75.0f);
    private StickSprite LST = new StickSprite("L", 164.0f, 160.0f, 20);
    private StickSprite RST = new StickSprite("R", 380.0f, 260.0f, 20);

    public void update(GamePadState gs) {
        this.gs = gs;
        this.A.setExist(gs.buttons.A);
        this.B.setExist(gs.buttons.B);
        this.X.setExist(gs.buttons.X);
        this.Y.setExist(gs.buttons.Y);
        this.RB.setExist(gs.buttons.RB);
        this.LB.setExist(gs.buttons.LB);
        this.RS.setExist(gs.buttons.RIGHT_STICK);
        this.LS.setExist(gs.buttons.LEFT_STICK);
        this.L.setExist(gs.buttons.POV_LEFT);
        this.R.setExist(gs.buttons.POV_RIGHT);
        this.U.setExist(gs.buttons.POV_UP);
        this.D.setExist(gs.buttons.POV_DOWN);
        this.BACK.setExist(gs.buttons.BACK);
        this.START.setExist(gs.buttons.START);
        this.LT.setWidth(gs.triggeres.LEFT.value * 100.0f);
        this.RT.setWidth(gs.triggeres.RIGHT.value * 100.0f);
        this.LST.setX(164.0f + gs.sticks.LEFT.x * 33.0f);
        this.LST.setY(160.0f + gs.sticks.LEFT.y * 33.0f);
        this.RST.setX(380.0f + gs.sticks.RIGHT.x * 33.0f);
        this.RST.setY(260.0f + gs.sticks.RIGHT.y * 33.0f);
    }

    @Override
    public void draw(GraphicsContext g) {
        g.drawImage(this.image.getImage(), 0, 0);
        this.A.draw(g);
        this.B.draw(g);
        this.X.draw(g);
        this.Y.draw(g);
        this.RB.draw(g);
        this.LB.draw(g);
        this.RS.draw(g);
        this.LS.draw(g);
        this.R.draw(g);
        this.L.draw(g);
        this.U.draw(g);
        this.D.draw(g);
        this.BACK.draw(g);
        this.START.draw(g);
        this.LT.draw(g);
        this.RT.draw(g);
        this.LST.draw(g);
        this.RST.draw(g);
    }
}

