/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.io.File;
import java.lang.reflect.Field;
import java.util.logging.Level;
import kinugasa.game.GameLog;
import kinugasa.resource.text.FileFormatException;
import kinugasa.resource.text.IniFile;

public class I18N {
    private static IniFile ini;

    static void init(String lang) {
        ini = new IniFile("translate/" + lang + ".ini").load();
        I18N.checkKey();
    }

    public I18N add(String lang, File dir) throws IllegalArgumentException {
        if (!dir.isDirectory() || !dir.exists()) {
            throw new IllegalArgumentException(dir + " is not directry");
        }
        Object p = dir.getPath();
        if (!((String)p).endsWith("/")) {
            p = (String)p + "/";
        }
        p = (String)p + lang;
        File f = new File((String)p + ".ini");
        ini.addAll(f.getPath());
        return this;
    }

    private static void checkKey() {
        for (Field f : Key.class.getDeclaredFields()) {
            if (ini.containsKey(f.getName())) continue;
            throw new FileFormatException("default ini is broken.");
        }
    }

    public static String translate(String key) {
        if (!ini.containsKey(key)) {
            GameLog.printIfUsing(Level.ALL, "unknown I18N key " + key);
            return "?";
        }
        return ini.get(key).get().value();
    }

    public static final class Key {
        public static final String CONFIRM = "CONFIRM";
        public static final String ARE_YOU_SURE_EXIT = "ARE_YOU_SURE_EXIT";
    }
}

