/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.swing.ImageIcon;
import kinugasa.game.CloseEvent;
import kinugasa.game.I18N;
import kinugasa.game.RenderingMagnification;
import kinugasa.game.ui.Dialog;
import kinugasa.game.ui.DialogIcon;
import kinugasa.game.ui.DialogOption;
import kinugasa.graphics.GraphicsUtil;
import kinugasa.graphics.RenderingQuality;
import kinugasa.resource.text.IniFile;

public class GameOption {
    private String title;
    private Color backColor;
    private Dimension windowSize;
    private Point windowLocation;
    private boolean lock;
    private boolean useMouse;
    private boolean useKeyboard;
    private boolean useGamePad;
    private boolean useLog;
    private String logPath;
    private int fps;
    private RenderingQuality rq;
    private RenderingMagnification rm;
    private String lang;
    private boolean updateIfNotActive;
    private String logName = "log_" + new SimpleDateFormat("yyyyMMddHHmmssSSS") + ".log";
    private ImageIcon icon = new ImageIcon(this.getClass().getResource("icon.png"));
    private CloseEvent closeEvent = () -> Dialog.yesOrNo(I18N.translate("CONFIRM"), DialogIcon.QUESTION, I18N.translate("ARE_YOU_SURE_EXIT")).is(DialogOption.YES);

    public static GameOption fromIni(String filename) {
        IniFile ini = new IniFile(filename).load();
        GameOption go = new GameOption(ini.get("TITLE").get().value());
        go.backColor = GraphicsUtil.createColor(ini.get("BG_COLOR").get().asCsv());
        int w = ini.get("SIZE").get().asCsvOf(0).asInt();
        int h = ini.get("SIZE").get().asCsvOf(1).asInt();
        go.windowSize = new Dimension(w, h);
        int x = ini.get("LOCATION").get().asCsvOf(0).asInt();
        int y = ini.get("LOCATION").get().asCsvOf(1).asInt();
        go.windowLocation = new Point(x, y);
        go.lock = ini.get("LOCK").get().isTrue();
        go.useMouse = ini.get("MOUSE").get().isTrue();
        go.useKeyboard = ini.get("KEY").get().isTrue();
        go.useGamePad = ini.get("GAMEPAD").get().isTrue();
        go.useLog = ini.get("LOG").get().isTrue();
        go.logPath = ini.get("LOG_PATH").get().value();
        go.fps = ini.get("FPS").get().asInt();
        go.rq = RenderingQuality.valueOf(ini.get("RENDERING_Q").get().value());
        go.rm = RenderingMagnification.valueOf(ini.get("RENDERING_M").get().value());
        go.lang = ini.get("LANG").get().value();
        go.updateIfNotActive = ini.get("UPDATE_IF_NOT_ACTIVE").get().isTrue();
        return go;
    }

    public static GameOption defaultOption() {
        return GameOption.fromIni("default.ini");
    }

    protected GameOption(String name) {
        this.title = name;
    }

    public GameOption setTitle(String title) {
        this.title = title;
        return this;
    }

    public GameOption setBackColor(Color backColor) {
        this.backColor = backColor;
        return this;
    }

    public GameOption setWindowSize(Dimension windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public GameOption setWindowLocation(Point windowLocation) {
        this.windowLocation = windowLocation;
        return this;
    }

    public GameOption setCenterOfScreen() {
        Point centerOfScreen = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.windowLocation.x = centerOfScreen.x - this.windowSize.width / 2;
        this.windowLocation.y = centerOfScreen.y - this.windowSize.height / 2;
        if (this.windowLocation.x < 0) {
            this.windowLocation.x = 0;
        }
        if (this.windowLocation.y < 0) {
            this.windowLocation.y = 0;
        }
        return this;
    }

    public GameOption setLock(boolean lock) {
        this.lock = lock;
        return this;
    }

    public GameOption setUseMouse(boolean useMouse) {
        this.useMouse = useMouse;
        return this;
    }

    public GameOption setUseKeyboard(boolean useKeyboard) {
        this.useKeyboard = useKeyboard;
        return this;
    }

    public void setUseGamePad(boolean useGamePad) {
        this.useGamePad = useGamePad;
    }

    public GameOption setUseLog(boolean useLog) {
        this.useLog = useLog;
        return this;
    }

    public GameOption setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public GameOption setFps(int fps) {
        this.fps = fps;
        return this;
    }

    public GameOption setRenderingQuality(RenderingQuality rq) {
        this.rq = rq;
        return this;
    }

    public GameOption setRenderingMagnification(RenderingMagnification rm) {
        this.rm = rm;
        return this;
    }

    public GameOption setLang(Locale l) {
        this.lang = l.getLanguage();
        return this;
    }

    public GameOption setLogName(String logName) {
        this.logName = logName;
        return this;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public GameOption setCloseEvent(CloseEvent closeEvent) {
        this.closeEvent = closeEvent;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public Dimension getWindowSize() {
        return this.windowSize;
    }

    public Point getWindowLocation() {
        return this.windowLocation;
    }

    public boolean isLock() {
        return this.lock;
    }

    public boolean isUseMouse() {
        return this.useMouse;
    }

    public boolean isUseKeyboard() {
        return this.useKeyboard;
    }

    public boolean isUseGamePad() {
        return this.useGamePad;
    }

    public boolean isUseLog() {
        return this.useLog;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public int getFps() {
        return this.fps;
    }

    public RenderingQuality getRenderingQuality() {
        return this.rq;
    }

    public RenderingMagnification getRenderingMagnification() {
        return this.rm;
    }

    public String getLang() {
        return this.lang;
    }

    public String getLogName() {
        return this.logName;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public CloseEvent getCloseEvent() {
        return this.closeEvent;
    }

    boolean isUpdateIfNotActive() {
        return this.updateIfNotActive;
    }

    public String toString() {
        return "GameOption{title=" + this.title + ", backColor=" + this.backColor + ", windowSize=" + this.windowSize + ", windowLocation=" + this.windowLocation + ", lock=" + this.lock + ", useMouse=" + this.useMouse + ", useKeyboard=" + this.useKeyboard + ", useLog=" + this.useLog + ", logPath=" + this.logPath + ", fps=" + this.fps + ", rq=" + this.rq + ", rm=" + this.rm + ", lang=" + this.lang + ", logName=" + this.logName + ", icon=" + this.icon + ", closeEvent=" + this.closeEvent + "}";
    }

    public static final class Key {
        public static final String TITLE = "TITLE";
        public static final String BG_COLOR = "BG_COLOR";
        public static final String SIZE = "SIZE";
        public static final String LOCATION = "LOCATION";
        public static final String LOCK = "LOCK";
        public static final String MOUSE = "MOUSE";
        public static final String KEY = "KEY";
        public static final String GAMEPAD = "GAMEPAD";
        public static final String LOG = "LOG";
        public static final String LOG_PATH = "LOG_PATH";
        public static final String FPS = "FPS";
        public static final String RENDERING_Q = "RENDERING_Q";
        public static final String RENDERING_M = "RENDERING_M";
        public static final String LANG = "LANG";
        public static final String UPDATE_IF_NOT_ACTIVE = "UPDATE_IF_NOT_ACTIVE";
    }
}

