/*
 * Decompiled with CFR 0.152.
 */
package hexfieldmapgametest;

import hexfieldmapgametest.BackgroundImageFrame;
import hexfieldmapgametest.ChipFrame;
import hexfieldmapgametest.FadeoutTextLabelSprite;
import hexfieldmapgametest.HexChip;
import hexfieldmapgametest.HexFieldMap;
import hexfieldmapgametest.MiniMapFrame;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import kinugasa.contents.graphics.GraphicsUtil;
import kinugasa.contents.graphics.ImageEditor;
import kinugasa.contents.text.CSVReader;
import kinugasa.contents.text.CSVWriter;
import kinugasa.game.GameConfig;
import kinugasa.game.KinugasaGame;
import kinugasa.game.LockUtil;
import kinugasa.game.PlayerConstants;
import kinugasa.game.WindowCloseEvent;
import kinugasa.inputDevice.InputState;
import kinugasa.inputDevice.InputType;
import kinugasa.inputDevice.Keys;
import kinugasa.inputDevice.MouseConnection;
import kinugasa.inputDevice.MouseState;
import kinugasa.object.ImageSprite;
import kinugasa.rpgui.ChipAttribute;
import kinugasa.rpgui.ChipAttributeStorage;
import kinugasa.rpgui.FontModel;
import kinugasa.ui.SimpleTextLabelModel;
import kinugasa.ui.TextLabelModel;
import kinugasa.ui.TextLabelModelStorage;
import kinugasa.ui.TextLabelSprite;

public class HexMapEditor
extends KinugasaGame {
    private HexFieldMap map;
    private TextLabelSprite fpsLabel;
    private Rectangle infoArea;
    private TextLabelSprite infoLabelSprite;
    private TextLabelSprite helpLabelSprite;
    private TextLabelSprite selectedChipLabelSprite;
    private Point prevSelectedLocation = new Point(-1, -1);
    private Point prevLocation;
    private boolean prevDrag = false;
    private MiniMapFrame miniMapFrame;
    private ChipFrame chipFrame;
    private static final int WINDOW_WIDTH = 1280;
    private static final int WINDOW_HEIGHT = 840;
    private HexChip selectedChip;
    private FadeoutTextLabelSprite cmdLabel;
    private ImageSprite backgroundImage;
    private BackgroundImageFrame bkImageFrame;
    private JFileChooser saveFileChooser;
    private JFileChooser loadFileChooser;
    private static final FileFilter CSV_FILEFILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".csv") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "CSV\u30d5\u30a1\u30a4\u30eb(*.csv)";
        }
    };
    private static int saveCount = 1;

    public static void main(String[] args) {
        LockUtil.deleteAllLockFile();
        new HexMapEditor().gameStart(args);
    }

    public HexMapEditor() {
        super(new GameConfig("Hex Map Editor").useMouse(true).setSize(1280, 840).setCenterOfScreen().setBackColor(Color.BLACK).setFps(60).setIcon("resource/icon.png").updateIfNotActive(true).addCloseEvent(new WindowCloseEvent("exitevent"){

            @Override
            public boolean close() {
                return JOptionPane.showConfirmDialog(null, "\u7d42\u4e86\u3057\u307e\u3059", "\u78ba\u8a8d", 2, 3) == 0;
            }
        }));
    }

    @Override
    protected void startUp() {
        this.map = new HexFieldMap(new Rectangle(-48, -48, 1328, 888)).builde();
        this.selectedChip = this.map.getCurrentChip();
        this.fpsLabel = new TextLabelSprite("", new SimpleTextLabelModel("FPSLABELMODEL", new FontModel("FPSLABELFONTMODEL", Color.CYAN, new Font("MONOSPACED", 0, 20))){

            @Override
            public void draw(Graphics2D g, TextLabelSprite l) {
                g.setColor(new Color(0, 0, 0, 172));
                g.fillRect((int)l.getX(), (int)l.getY(), (int)l.getWidth(), (int)l.getHeight());
                super.draw(g, l);
            }
        }, 12.0f, 12.0f, 112.0f, 24.0f);
        this.infoArea = new Rectangle(0, 816, 1280, 32);
        this.infoLabelSprite = new TextLabelSprite("x=0 y=0", new SimpleTextLabelModel("INFOLABEL", FontModel.DEFAULT.clone().setColor(Color.WHITE)), 8.0f, 816.0f, 280.0f, 20.0f);
        this.helpLabelSprite = new TextLabelSprite("\u3010\u64cd\u4f5c\u65b9\u6cd5\u3011\u53f3\u30c9\u30e9\u30c3\u30b0\u3067\u79fb\u52d5, m:\u30df\u30cb\u30de\u30c3\u30d7, r:\u8868\u793a\u4f4d\u7f6e\u3092\u623b\u3059, c:\u30c1\u30c3\u30d7\u9078\u629e, s:\u30bb\u30fc\u30d6, l:\u30ed\u30fc\u30c9, b:\u80cc\u666f\u753b\u50cf", (TextLabelModel)TextLabelModelStorage.getInstance().get("INFOLABEL"), 180.0f, 816.0f, 280.0f, 20.0f);
        this.selectedChipLabelSprite = new TextLabelSprite("\u9078\u629e\u4e2d", (TextLabelModel)TextLabelModelStorage.getInstance().get("INFOLABEL"), 1140.0f, 2.0f, 280.0f, 20.0f);
        this.cmdLabel = new FadeoutTextLabelSprite("\u4fdd\u5b58\u3057\u307e\u3057\u305f", 48.0f, 48.0f, 280.0f, 24.0f);
        this.cmdLabel.setVisible(false);
    }

    public void setSelectedChip(String chipName) {
        this.selectedChip = new HexChip(chipName, this.map.getImageMap().get(chipName), (ChipAttribute)ChipAttributeStorage.getInstance().get("VOID"));
    }

    public ImageSprite getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(ImageSprite backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    @Override
    protected void dispose() {
    }

    @Override
    protected void update() {
        this.fpsLabel.setText("FPS:" + this.getGameTimeManager().getFPSStr(2));
        InputState is = InputState.getInstance();
        this.mouseProc(is);
        this.keyProc(is);
    }

    private void mouseProc(InputState is) {
        MouseState ms = MouseConnection.getState();
        if (ms.RIGHT_BUTTON) {
            this.getWindow().setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.getWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
        if (ms.DRAG_NOW) {
            if (ms.LEFT_BUTTON) {
                Point mp = ms.getDraggedLocation();
                mp.x -= this.getWindow().getBounds().width - this.getWindow().getInternalBounds().width;
                mp.y -= this.getWindow().getBounds().height - this.getWindow().getInternalBounds().height;
                mp.x -= this.map.getDrawLocation().x;
                mp.y -= this.map.getDrawLocation().y;
                int readImageWidth = this.map.getRealImageSize().width;
                int readImageHeight = this.map.getRealImageSize().height;
                this.map.setSelectedLocation(new Point(mp.x / readImageWidth, mp.x / readImageWidth % 2 == 0 ? (mp.y - this.map.getYGap()) / readImageHeight : mp.y / readImageHeight));
                if (!this.map.getSelectedLocation().equals(this.prevSelectedLocation)) {
                    this.prevSelectedLocation = this.map.getSelectedLocation();
                    this.infoLabelSprite.setText("x=" + this.map.getSelectedLocation().x + " y=" + this.map.getSelectedLocation().y);
                }
                this.map.setChip(this.selectedChip);
                if (this.miniMapFrame != null && this.miniMapFrame.isVisible()) {
                    this.miniMapFrame.setImage(ImageEditor.resize(this.map.createMiniMap(), 4.0f));
                }
            } else if (ms.RIGHT_BUTTON) {
                if (!this.prevDrag) {
                    this.prevLocation = ms.getLocation();
                    this.prevDrag = true;
                }
                Point currentLocation = ms.getDraggedLocation();
                this.map.addDrawLocation(currentLocation.x - this.prevLocation.x, currentLocation.y - this.prevLocation.y);
                this.prevLocation = (Point)currentLocation.clone();
            }
        } else {
            this.prevDrag = false;
            Point mp = ms.getLocation();
            mp.x -= this.getWindow().getBounds().width - this.getWindow().getInternalBounds().width;
            mp.y -= this.getWindow().getBounds().height - this.getWindow().getInternalBounds().height;
            mp.x -= this.map.getDrawLocation().x;
            mp.y -= this.map.getDrawLocation().y;
            int readImageWidth = this.map.getRealImageSize().width;
            int readImageHeight = this.map.getRealImageSize().height;
            this.map.setSelectedLocation(new Point(mp.x / readImageWidth, mp.x / readImageWidth % 2 == 0 ? (mp.y - this.map.getYGap()) / readImageHeight : mp.y / readImageHeight));
            if (!this.map.getSelectedLocation().equals(this.prevSelectedLocation)) {
                this.prevSelectedLocation = this.map.getSelectedLocation();
                this.infoLabelSprite.setText("x=" + this.map.getSelectedLocation().x + " y=" + this.map.getSelectedLocation().y);
            }
            if (ms.LEFT_BUTTON) {
                this.map.setChip(this.selectedChip);
                if (this.miniMapFrame != null && this.miniMapFrame.isVisible()) {
                    this.miniMapFrame.setImage(ImageEditor.resize(this.map.createMiniMap(), 4.0f));
                }
            }
            if (ms.RIGHT_BUTTON) {
                this.selectedChip = this.map.getCurrentChip();
            }
        }
    }

    private void keyProc(InputState is) {
        HexMapEditor GAME;
        if (is.isPressed(Keys.M, InputType.SINGLE)) {
            if (this.miniMapFrame != null && this.miniMapFrame.isVisible()) {
                this.miniMapFrame.setVisible(false);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HexMapEditor.this.miniMapFrame == null) {
                            HexMapEditor.this.miniMapFrame = new MiniMapFrame();
                        }
                        HexMapEditor.this.miniMapFrame.setImage(ImageEditor.resize(HexMapEditor.this.map.createMiniMap(), 4.0f));
                        HexMapEditor.this.miniMapFrame.setVisible(true);
                    }
                });
            }
        }
        if (is.isPressed(Keys.R, InputType.SINGLE)) {
            this.map.setDrawLocation(new Point(0, 0));
        }
        if (is.isPressed(Keys.C, InputType.SINGLE)) {
            if (this.chipFrame != null && this.chipFrame.isVisible()) {
                this.chipFrame.setVisible(false);
            } else {
                GAME = this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HexMapEditor.this.chipFrame == null) {
                            HexMapEditor.this.chipFrame = new ChipFrame(GAME, HexMapEditor.this.map.getImageMap());
                        }
                        HexMapEditor.this.chipFrame.setVisible(true);
                    }
                });
            }
        }
        if (is.isPressed(Keys.S, InputType.SINGLE)) {
            if (this.saveFileChooser == null) {
                this.saveFileChooser = new JFileChooser();
            }
            this.saveFileChooser.setSelectedFile(new File(PlayerConstants.getInstance().DESKTOP_PATH + "/map" + saveCount++ + ".csv"));
            if (0 == this.saveFileChooser.showSaveDialog(null)) {
                HexChip[][] data = this.map.getMapData();
                CSVWriter writer = new CSVWriter(this.saveFileChooser.getSelectedFile());
                for (int y = 0; y < data.length; ++y) {
                    String[] line = new String[data[y].length];
                    for (int x = 0; x < data[y].length; ++x) {
                        line[x] = data[y][x].getName();
                    }
                    writer.add(line);
                }
                writer.save();
                this.cmdLabel.setText("\u30bb\u30fc\u30d6\u3057\u307e\u3057\u305f");
                this.cmdLabel.reset();
                this.cmdLabel.setVisible(true);
            }
        }
        if (is.isPressed(Keys.L, InputType.SINGLE)) {
            if (this.loadFileChooser == null) {
                this.loadFileChooser = new JFileChooser();
                this.loadFileChooser.setAcceptAllFileFilterUsed(false);
                this.loadFileChooser.addChoosableFileFilter(CSV_FILEFILTER);
            }
            this.loadFileChooser.setSelectedFile(new File(PlayerConstants.getInstance().DESKTOP_PATH + "/"));
            if (0 == this.loadFileChooser.showOpenDialog(null)) {
                CSVReader reader = new CSVReader(this.loadFileChooser.getSelectedFile());
                reader.load();
                ArrayList csvData = reader.getData();
                HexChip[][] data = new HexChip[csvData.size()][];
                for (int y = 0; y < csvData.size(); ++y) {
                    String[] line = (String[])csvData.get(y);
                    data[y] = new HexChip[line.length];
                    for (int x = 0; x < line.length; ++x) {
                        data[y][x] = this.map.getChip(line[x]);
                    }
                }
                this.map.setMapData(data);
                reader.free();
                this.cmdLabel.setText("\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f \u30b5\u30a4\u30ba\uff1a" + data.length + ":" + data[0].length);
                this.cmdLabel.reset();
                this.cmdLabel.setVisible(true);
                if (this.miniMapFrame != null && this.miniMapFrame.isVisible()) {
                    this.miniMapFrame.setImage(ImageEditor.resize(this.map.createMiniMap(), 4.0f));
                }
            }
        }
        if (is.isPressed(Keys.B, InputType.SINGLE)) {
            if (this.bkImageFrame != null && this.bkImageFrame.isVisible()) {
                this.bkImageFrame.setVisible(false);
            } else {
                GAME = this;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (HexMapEditor.this.bkImageFrame == null) {
                            HexMapEditor.this.bkImageFrame = new BackgroundImageFrame(GAME);
                        }
                        HexMapEditor.this.bkImageFrame.setVisible(true);
                    }
                });
            }
        }
    }

    @Override
    protected void draw(Graphics2D g) {
        if (this.backgroundImage != null && this.backgroundImage.isVisible()) {
            this.backgroundImage.setLocation(this.map.getDrawLocation().x, this.map.getDrawLocation().y);
            this.backgroundImage.draw(g);
        }
        this.map.draw(g);
        this.fpsLabel.draw(g);
        g.setColor(Color.DARK_GRAY);
        GraphicsUtil.fillRect(g, this.infoArea);
        this.infoLabelSprite.draw(g);
        g.fillRect(1130, 0, 222, 54);
        this.selectedChipLabelSprite.draw(g);
        if (this.selectedChip != null) {
            g.drawImage((Image)this.selectedChip.getImage(), 1220, 4, null);
        }
        this.helpLabelSprite.draw(g);
        this.cmdLabel.draw(g);
    }
}

