/*
 * Decompiled with CFR 0.152.
 */
package hexfieldmapgametest;

import hexfieldmapgametest.HexChip;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import kinugasa.contents.graphics.ARGBColor;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.text.INIReader;
import kinugasa.game.GameLog;
import kinugasa.object.Drawable;

public class HexFieldMap
implements Drawable {
    private HexChip[][] mapData;
    private Map<String, BufferedImage> imageMap;
    private Point selectedLocation = new Point(0, 0);
    private int yGap;
    private Dimension imageSize;
    private Dimension realImageSize;
    private Rectangle bounds;
    private String selectChipName;
    private String baseChipName;
    private Point drawLocation = new Point(0, 0);
    public static final int NOT_FOUND = -1;

    public HexFieldMap(Rectangle bounds) {
        this.bounds = bounds;
    }

    public HexFieldMap builde() {
        INIReader iniReader = new INIReader("conf.ini").load();
        iniReader.printAll(System.out);
        int mapWidth = Integer.parseInt(iniReader.get("WIDTH").getValue());
        int mapHeight = Integer.parseInt(iniReader.get("HEIGHT").getValue());
        int cutSize = Integer.parseInt(iniReader.get("CUTSIZE").getValue());
        String chipSetFileName = iniReader.get("CHIPSET").getValue();
        this.selectChipName = iniReader.get("SELECT").getValue();
        this.baseChipName = iniReader.get("BASE").getValue();
        this.imageMap = ImageUtil.splitAsMapN(ImageUtil.load(chipSetFileName), cutSize, cutSize, 4);
        this.mapData = new HexChip[mapHeight][];
        for (int i = 0; i < mapHeight; ++i) {
            this.mapData[i] = new HexChip[mapWidth];
            for (int j = 0; j < this.mapData[i].length; ++j) {
                this.mapData[i][j] = new HexChip(this.selectChipName, this.imageMap.get(this.baseChipName));
            }
        }
        iniReader.free();
        this.imageSize = new Dimension(this.imageMap.get(this.baseChipName).getWidth(), this.imageMap.get(this.baseChipName).getHeight());
        this.realImageSize = new Dimension(this.imageMap.get(this.baseChipName).getWidth() / 2 + this.getXGap(this.imageMap.get(this.baseChipName)) + 1, this.imageSize.height);
        GameLog.printInfo("HexFieldMap\u521d\u671f\u8a2d\u5b9a\u5b8c\u4e86 size=" + this.mapData[0].length + ":" + this.mapData.length);
        return this;
    }

    public HexChip getChip(String key) {
        return new HexChip(key, this.imageMap.get(key));
    }

    public void setMapData(HexChip[][] mapData) {
        this.mapData = mapData;
        this.setSelectedLocation(new Point(0, 0));
    }

    public void setSelectedLocation(Point selectedLocation) {
        Point location = (Point)selectedLocation.clone();
        if (this.mapData == null || this.mapData.length == 0) {
            return;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y >= this.mapData.length) {
            location.y = this.mapData.length - 1;
        }
        if (location.x >= this.mapData[location.y].length) {
            location.x = this.mapData[location.y].length - 1;
        }
        this.selectedLocation = location;
    }

    public Point getSelectedLocation() {
        return this.selectedLocation;
    }

    public int getYGap() {
        return this.yGap;
    }

    public Dimension getRealImageSize() {
        return this.realImageSize;
    }

    public HexChip getChip(int x, int y) throws ArrayIndexOutOfBoundsException {
        return this.mapData[y][x];
    }

    public void setChip(int x, int y, HexChip chip) throws ArrayIndexOutOfBoundsException {
        this.mapData[y][x] = chip;
    }

    public HexChip[][] getMapData() {
        return this.mapData;
    }

    public void setChip(HexChip chip) throws ArrayIndexOutOfBoundsException {
        this.mapData[this.selectedLocation.y][this.selectedLocation.x] = chip;
    }

    public HexChip getCurrentChip() {
        return this.mapData[this.selectedLocation.y][this.selectedLocation.x];
    }

    @Override
    public void draw(Graphics2D g) {
        int xGap = this.imageMap.get(this.baseChipName).getWidth() / 2 + this.getXGap(this.imageMap.get(this.baseChipName)) + 1;
        int imageHeight = this.imageMap.get(this.baseChipName).getHeight();
        this.yGap = imageHeight / 2;
        for (int y = 0; y < this.mapData.length; ++y) {
            for (int x = 0; x < this.mapData[y].length; ++x) {
                int drawX = this.drawLocation.x + x * xGap;
                int drawY = this.drawLocation.y + y * imageHeight;
                if (x % 2 == 0) {
                    drawY += this.yGap;
                }
                if (this.bounds.contains(drawX, drawY)) {
                    g.drawImage((Image)this.mapData[y][x].getImage(), drawX, drawY, null);
                }
                if (y != this.selectedLocation.y || x != this.selectedLocation.x) continue;
                g.drawImage((Image)this.imageMap.get(this.selectChipName), drawX, drawY, null);
            }
        }
    }

    public void setDrawLocation(Point drawLocation) {
        this.drawLocation = drawLocation;
    }

    public Point getDrawLocation() {
        return this.drawLocation;
    }

    private int getXGap(BufferedImage sampleImage) {
        int[] pix = ImageUtil.getPixel(sampleImage);
        for (int result = 0; result < pix.length; ++result) {
            if (ARGBColor.isTransparent(pix[result])) continue;
            return result - 1;
        }
        return -1;
    }

    public BufferedImage createMiniMap() {
        BufferedImage resultImage = ImageUtil.newImage(this.mapData[0].length, this.mapData.length);
        int[][] pix = ImageUtil.getPixel2D(resultImage);
        for (int y = 0; y < this.mapData.length; ++y) {
            for (int x = 0; x < this.mapData[y].length; ++x) {
                BufferedImage chipImage = this.mapData[y][x].getImage();
                int w = chipImage.getWidth() / 2;
                int h = chipImage.getHeight() / 2;
                pix[y][x] = ImageUtil.getPixel(chipImage, w, h);
            }
        }
        ImageUtil.setPixel2D(resultImage, pix);
        pix = null;
        return resultImage;
    }

    public void addDrawLocation(int x, int y) {
        this.drawLocation.x += x;
        this.drawLocation.y += y;
    }

    public Map<String, BufferedImage> getImageMap() {
        return this.imageMap;
    }
}

