/*
 * Decompiled with CFR 0.152.
 */
package hexfieldmapgametest;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kinugasa.contents.graphics.FadeCounter;
import kinugasa.rpgui.FontModel;
import kinugasa.ui.TextLabelModel;
import kinugasa.ui.TextLabelSprite;
import kinugasa.util.FrameTimeCounter;

public class FadeLabelModel
extends TextLabelModel {
    private static final long serialVersionUID = 1L;
    private FadeCounter fadeCounter = new FadeCounter(255, -1);
    private FrameTimeCounter fadeStartCount = new FrameTimeCounter(60);

    public FadeLabelModel() {
        super("FadeLabelModel", new FontModel("FADE_LABEL", Color.WHITE, new Font("MONOSPACED", 0, 14)));
    }

    public void reset() {
        this.fadeCounter = new FadeCounter(255, -1);
        this.fadeStartCount = new FrameTimeCounter(60);
    }

    @Override
    public void draw(Graphics2D g, TextLabelSprite l) {
        g.setColor(new Color(0, 0, 0, this.fadeCounter.getValue() > 144 ? 144 : this.fadeCounter.getValue()));
        g.fillRect((int)l.getX() - 6, (int)l.getY(), (int)l.getWidth(), (int)l.getHeight());
        this.setProperty(g);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.drawString(l.getText(), (int)l.getX(), (int)(l.getY() + (float)this.getFontSize()));
        if (this.fadeStartCount == null) {
            this.fadeCounter.update();
        } else if (this.fadeStartCount.isReaching()) {
            this.fadeStartCount = null;
        }
        if (this.fadeCounter.getValue() < 0) {
            l.setVisible(false);
            return;
        }
        this.getFontConfig().setColor(new Color(255, 255, 255, this.fadeCounter.getValue()));
    }
}

