/*
 * Decompiled with CFR 0.152.
 */
package hexfieldmapgametest;

import hexfieldmapgametest.HexMapEditor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import kinugasa.contents.graphics.ImageEditor;
import kinugasa.contents.graphics.ImageUtil;

public class ChipFrame
extends JFrame {
    private HexMapEditor game;
    private JPanel jPanel1;

    public ChipFrame(HexMapEditor game, Map<String, BufferedImage> imageMap) {
        this.initComponents();
        this.setIconImage(ImageUtil.load("resource/icon.png"));
        this.game = game;
        this.setButton(imageMap);
    }

    private void setButton(Map<String, BufferedImage> imageMap) {
        ArrayList<String> keyList = new ArrayList<String>(imageMap.keySet());
        Collections.sort(keyList);
        String lastKey = (String)keyList.get(keyList.size() - 1);
        int maxYIndex = Integer.parseInt(lastKey.substring(0, 4));
        int maxXIndex = Integer.parseInt(lastKey.substring(4, 8));
        this.jPanel1.setLayout(new GridLayout(maxYIndex, maxXIndex));
        for (String key : keyList) {
            this.jPanel1.add(new ImageButton(this.game, key, ImageEditor.resize(imageMap.get(key), 0.5f)));
        }
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Chips");
        this.jPanel1.setLayout(new GridLayout(1, 0));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 383, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 250, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private static final class ImageButtonAction
    implements ActionListener {
        private HexMapEditor game;
        private ImageButton btn;

        public ImageButtonAction(HexMapEditor game, ImageButton btn) {
            this.game = game;
            this.btn = btn;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.game.setSelectedChip(this.btn.getName());
        }
    }

    private static final class ImageButton
    extends JButton {
        private HexMapEditor game;

        public ImageButton(HexMapEditor game, String name, BufferedImage image) {
            this.game = game;
            this.setName(name);
            this.setToolTipText(name);
            this.setIcon(new ImageIcon(image));
            this.init();
        }

        private void init() {
            this.addActionListener(new ImageButtonAction(this.game, this));
        }
    }
}

