/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.util;

import java.util.Arrays;
import kinugasa.util.ArrayIndexModel;
import kinugasa.util.SimpleIndex;
import kinugasa.util.TimeCounter;

public class FrameTimeCounter
extends TimeCounter {
    private static final long serialVersionUID = 8128288858943550667L;
    private int timeCount;
    private int speed;
    private ArrayIndexModel index;
    private ArrayIndexModel initialIndex;
    private int[] waitTime;
    private boolean running;

    public FrameTimeCounter(int ... waitTime) {
        int[] nArray;
        if (waitTime.length == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = waitTime;
        }
        this(1, nArray);
    }

    public FrameTimeCounter(int speed, int[] waitTime) {
        this(speed, new SimpleIndex(), waitTime);
    }

    public FrameTimeCounter(ArrayIndexModel index, int ... waitTime) {
        this(1, index, waitTime);
    }

    public FrameTimeCounter(int speed, ArrayIndexModel index, int ... waitTime) {
        if (waitTime.length == 0) {
            waitTime = new int[]{0};
        }
        this.speed = speed;
        this.index = index;
        this.waitTime = waitTime;
        this.timeCount = waitTime[index.index(waitTime.length)];
        this.initialIndex = index.clone();
    }

    @Override
    public FrameTimeCounter clone() {
        FrameTimeCounter result = (FrameTimeCounter)super.clone();
        result.index = this.index.clone();
        result.waitTime = (int[])this.waitTime.clone();
        return result;
    }

    @Override
    public boolean isReaching() {
        this.running = true;
        this.timeCount -= this.speed;
        if (this.timeCount < 0) {
            this.timeCount = this.waitTime[this.index.index(this.waitTime.length)];
            return true;
        }
        return false;
    }

    public void initCount() {
        this.timeCount = this.waitTime[this.index.getIndex()];
    }

    public void setIndex(ArrayIndexModel index) {
        this.index = index;
        this.initCount();
    }

    public void setIndex(int index) {
        this.timeCount = this.waitTime[index];
    }

    public ArrayIndexModel getIndex() {
        return this.index;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getTimeCount() {
        return this.timeCount;
    }

    public void setTimeCount(int timeCount) {
        this.timeCount = timeCount;
    }

    public int[] getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int ... waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public boolean isEnded() {
        return false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void reset() {
        this.index = this.initialIndex.clone();
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + this.timeCount;
        hash = 67 * hash + this.speed;
        hash = 67 * hash + (this.index != null ? this.index.hashCode() : 0);
        hash = 67 * hash + Arrays.hashCode(this.waitTime);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrameTimeCounter other = (FrameTimeCounter)obj;
        if (this.timeCount != other.timeCount) {
            return false;
        }
        if (this.speed != other.speed) {
            return false;
        }
        if (!(this.index == other.index || this.index != null && this.index.equals(other.index))) {
            return false;
        }
        return Arrays.equals(this.waitTime, other.waitTime);
    }

    public String toString() {
        return "FrameTimeCounter{timeCount=" + this.timeCount + ", speed=" + this.speed + ", index=" + this.index + ", waitTime=" + Arrays.toString(this.waitTime) + '}';
    }
}

