/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.rpgui;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kinugasa.contents.resource.DuplicateNameException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.resource.Storage;
import kinugasa.rpgui.ChipAttribute;
import kinugasa.rpgui.ChipAttributeStorage;
import kinugasa.rpgui.VehicleStorage;

public class Vehicle
implements Nameable,
Serializable,
Comparable<Vehicle> {
    private static final long serialVersionUID = -5624691892456676247L;
    private String name;
    private float speed;
    private Storage<ChipAttribute> attributeStorage;

    public Vehicle(String name, float speed, ChipAttribute ... attributeSet) throws DuplicateNameException {
        this(name, speed, Arrays.asList(attributeSet));
    }

    public Vehicle(String name, float speed, Collection<ChipAttribute> attributeSet) throws DuplicateNameException {
        if (VehicleStorage.getInstance().contains(name)) {
            throw new DuplicateNameException("duplicate name : " + name);
        }
        this.name = name;
        this.speed = speed;
        this.attributeStorage = new Storage();
        this.attributeStorage.addAll(attributeSet);
        this.addThis();
    }

    private void addThis() {
        VehicleStorage.getInstance().add(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public Storage<ChipAttribute> getAttributeStorage() {
        return this.attributeStorage;
    }

    public boolean stepOn(ChipAttribute attribute) {
        if (((ChipAttribute)ChipAttributeStorage.getInstance().get("CLOSE")).equals(attribute)) {
            return false;
        }
        if (((ChipAttribute)ChipAttributeStorage.getInstance().get("VOID")).equals(attribute)) {
            return true;
        }
        return this.attributeStorage.contains(attribute);
    }

    public boolean stepOn(List<ChipAttribute> attr) {
        int size = attr.size();
        for (int i = 0; i < size; ++i) {
            if (this.stepOn(attr.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Vehicle{name=" + this.name + ", speed=" + this.speed + ", attributeStorage=" + this.attributeStorage + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vehicle other = (Vehicle)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(Vehicle o) {
        return this.name.compareTo(o.getName());
    }
}

