/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.rpgui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.graphics.RenderingPolicy;
import kinugasa.contents.resource.Loadable;
import kinugasa.rpgui.FontModel;
import kinugasa.rpgui.MessageWindowModel;
import kinugasa.rpgui.MessageWindowSprite;

public class SimpleMessageWindowModel
extends MessageWindowModel
implements Loadable {
    private Color primaryColor;
    private Color secondaryColor;
    private FontModel font;
    private float lineGap;
    private float firstLineXGap = 8.0f;
    private float yGap = 12.0f;
    private float borderWidth;
    private boolean textAntiAlias = true;
    private BufferedImage backgroundImage;
    private boolean initSelectIcon = false;
    private float width;
    private float height;

    public SimpleMessageWindowModel(String name, Color primaryColor, Color secondaryColor, FontModel font, float lineGap, float borderWidth) {
        super(name);
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.font = font;
        this.lineGap = lineGap;
        this.borderWidth = borderWidth;
    }

    @Override
    public void draw(Graphics2D g, MessageWindowSprite w) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.backgroundImage == null || w.getWidth() != this.width || w.getHeight() != this.height) {
            this.setSize(w.getWidth(), w.getHeight());
            this.load();
        }
        if (this.textAntiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        g2.drawImage((Image)this.backgroundImage, (int)w.getX(), (int)w.getY(), null);
        g2.setColor(this.font.getColor());
        g2.setFont(this.font.getFont());
        String[] data = w.split();
        float fontSize = this.font.getFont().getSize2D();
        float x = w.getX() + this.firstLineXGap;
        float y = w.getY() + fontSize + this.yGap;
        for (int i = 0; i < data.length; ++i) {
            g2.drawString(data[i], x, y + (float)i * (fontSize + this.lineGap));
        }
        w.getCurrentText().isReachingNextCher();
        if (w.getCurrentText().isVisibleAllChar()) {
            if (!w.getCurrentText().hasNext() || w.getCurrentText().getNextIdNum() <= 1) {
                if (w.getContinueIcon() != null && w.getContinueIcon().isVisible()) {
                    w.getContinueIcon().draw(g);
                }
            } else if (w.getSelectIcon() != null) {
                if (!this.initSelectIcon) {
                    this.initSelectIcon = true;
                }
                w.getSelectIcon().draw(g);
            }
        } else {
            this.initSelectIcon = false;
        }
        g2.dispose();
    }

    @Override
    public boolean isLoaded() {
        return this.backgroundImage != null;
    }

    @Override
    public SimpleMessageWindowModel load() {
        if (this.width != 0.0f & this.height != 0.0f) {
            int w = (int)this.width;
            int h = (int)this.height;
            this.backgroundImage = ImageUtil.newImage(w, h);
            Graphics2D g = ImageUtil.createGraphics2D(this.backgroundImage, RenderingPolicy.QUALITY);
            g.setColor(this.primaryColor);
            g.fillRect(0, 0, w, h);
            g.setColor(this.secondaryColor);
            g.fillRect((int)this.borderWidth, (int)this.borderWidth, w - (int)(this.borderWidth * 2.0f), h - (int)(this.borderWidth * 2.0f));
            g.setColor(this.secondaryColor);
            g.fillRect((int)(this.borderWidth * 2.0f), (int)(this.borderWidth * 2.0f), w - (int)(this.borderWidth * 3.0f), h - (int)(this.borderWidth * 3.0f));
            g.dispose();
        }
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public SimpleMessageWindowModel setWidth(float width) {
        this.width = width;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public SimpleMessageWindowModel setHeight(float height) {
        this.height = height;
        return this;
    }

    public SimpleMessageWindowModel setSize(float w, float h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public SimpleMessageWindowModel setPrimaryColor(Color primaryColor) {
        this.primaryColor = primaryColor;
        return this;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public SimpleMessageWindowModel setSecondaryColor(Color secondaryColor) {
        this.secondaryColor = secondaryColor;
        return this;
    }

    public FontModel getFont() {
        return this.font;
    }

    public SimpleMessageWindowModel setFont(FontModel font) {
        this.font = font;
        return this;
    }

    public float getLineGap() {
        return this.lineGap;
    }

    public SimpleMessageWindowModel setLineGap(float lineGap) {
        this.lineGap = lineGap;
        return this;
    }

    public float getFirstLineXGap() {
        return this.firstLineXGap;
    }

    public SimpleMessageWindowModel setFirstLineXGap(float firstLineXGap) {
        this.firstLineXGap = firstLineXGap;
        return this;
    }

    public float getFirstLineYGap() {
        return this.yGap;
    }

    public SimpleMessageWindowModel setFirstLineYGap(float firstLineYGap) {
        this.yGap = firstLineYGap;
        return this;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public SimpleMessageWindowModel setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public boolean isTextAntiAlias() {
        return this.textAntiAlias;
    }

    public SimpleMessageWindowModel setTextAntiAlias(boolean textAntiAlias) {
        this.textAntiAlias = textAntiAlias;
        return this;
    }

    @Override
    public SimpleMessageWindowModel clone() {
        return (SimpleMessageWindowModel)super.clone();
    }
}

