/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.rpgui;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import kinugasa.contents.graphics.Animation;
import kinugasa.contents.resource.Disposable;
import kinugasa.object.AnimationSprite;
import kinugasa.rpgui.ChipAttribute;
import kinugasa.rpgui.MapChip;
import kinugasa.rpgui.MapData;
import kinugasa.rpgui.Vehicle;
import kinugasa.rpgui.VehicleStorage;
import kinugasa.util.TimeCounter;

public class MapLayerSprite
extends AnimationSprite
implements Disposable {
    private static final long serialVersionUID = -5233491178202270274L;
    private MapData[] mapData;

    public MapLayerSprite(float x, float y, float w, float h, TimeCounter tc, MapData ... mapData) {
        super(x, y, w, h);
        this.mapData = mapData;
        BufferedImage[] images = new BufferedImage[mapData.length];
        for (int i = 0; i < mapData.length; ++i) {
            images[i] = mapData[i].getImage();
        }
        this.setAnimation(new Animation(tc, images));
    }

    @Override
    public void dispose() {
        for (MapData data : this.mapData) {
            data.dispose();
        }
        this.setAnimation(null);
    }

    public MapData[] getMapData() {
        return this.mapData;
    }

    public MapData getCurrentMapData() {
        return this.mapData[this.getAnimation().getIndex().getIndex()];
    }

    public int mapNum() {
        return this.mapData.length;
    }

    public MapData getMapData(int index) throws ArrayIndexOutOfBoundsException {
        return this.mapData[index];
    }

    public MapChip[] getChip(int x, int y) throws ArrayIndexOutOfBoundsException {
        MapChip[] chips = new MapChip[this.mapData.length];
        int size = this.mapNum();
        for (int i = 0; i < size; ++i) {
            chips[i] = this.mapData[i].getChips()[y][x];
        }
        return chips;
    }

    public ChipAttribute[] getAttribute(int x, int y) throws ArrayIndexOutOfBoundsException {
        ChipAttribute[] attributes = new ChipAttribute[this.mapData.length];
        int size = this.mapNum();
        for (int i = 0; i < size; ++i) {
            attributes[i] = this.mapData[i].getChips()[y][x].getAttribute();
        }
        return attributes;
    }

    public boolean stepOn(int x, int y) {
        return this.stepOn(VehicleStorage.getInstance().getCurrentVehicle(), x, y);
    }

    public boolean stepOn(Vehicle vehicle, int x, int y) {
        if (vehicle == null) {
            return true;
        }
        for (ChipAttribute attribute : this.getAttribute(x, y)) {
            if (vehicle.stepOn(attribute)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "FieldMapDataLayer{mapData=" + Arrays.toString(this.mapData) + '}';
    }
}

