/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.rpgui;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.DuplicateNameException;
import kinugasa.contents.resource.IllegalXMLFormatException;
import kinugasa.contents.resource.Storage;
import kinugasa.contents.sound.LoopPoint;
import kinugasa.contents.sound.SoundBuilder;
import kinugasa.contents.sound.SoundMap;
import kinugasa.contents.text.XMLAttribute;
import kinugasa.contents.text.XMLAttributeStorage;
import kinugasa.contents.text.XMLElement;
import kinugasa.contents.text.XMLFileSupport;
import kinugasa.contents.text.XMLReader;
import kinugasa.game.GameLog;
import kinugasa.object.FourDirection;
import kinugasa.rpgui.FieldMapBuilder;
import kinugasa.rpgui.Node;
import kinugasa.rpgui.NodeAccepter;
import kinugasa.rpgui.NodeAccepterStorage;
import kinugasa.rpgui.NodeMap;
import kinugasa.rpgui.XMLFieldMapBuilder;
import kinugasa.util.StopWatch;
import kinugasa.util.StringUtil;

public final class FieldMapBuilderStorage
extends Storage<FieldMapBuilder>
implements XMLFileSupport {
    private static final FieldMapBuilderStorage INSTANCE = new FieldMapBuilderStorage();
    private int x;
    private int y;
    private int width;
    private int height;

    private FieldMapBuilderStorage() {
    }

    public static FieldMapBuilderStorage getInstance() {
        return INSTANCE;
    }

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, ContentsFileNotFoundException, ContentsIOException, DuplicateNameException, NumberFormatException {
        StopWatch watch = new StopWatch().start();
        XMLReader reader = new XMLReader(filePath).load();
        XMLElement root = (XMLElement)reader.getFirst();
        if (!"kinugasaFieldMapBuilder".equals(root.getName())) {
            throw new IllegalXMLFormatException("illegal root node name :" + root);
        }
        this.x = ((XMLAttribute)root.getAttributes().get("x")).getIntValue();
        this.y = ((XMLAttribute)root.getAttributes().get("y")).getIntValue();
        this.width = ((XMLAttribute)root.getAttributes().get("width")).getIntValue();
        this.height = ((XMLAttribute)root.getAttributes().get("height")).getIntValue();
        List<XMLElement> fieldMapList = root.getElement("fieldMap");
        int size = fieldMapList.size();
        for (int i = 0; i < size; ++i) {
            XMLElement fieldMapElement = fieldMapList.get(i);
            String fieldMapName = ((XMLAttribute)fieldMapElement.getAttributes().get("name")).getValue();
            XMLReader dataFileReader = new XMLReader(((XMLAttribute)fieldMapElement.getAttributes().get("data")).getValue());
            SoundMap bgmMap = this.createSoundMap(fieldMapName, fieldMapElement.getElement("bgm"));
            NodeMap nodeMap = this.createNodeMap(fieldMapElement.getElement("node"));
            String textDataPath = null;
            if (fieldMapElement.hasElement("textData")) {
                textDataPath = ((XMLAttribute)fieldMapElement.getElement("textData").get(0).getAttributes().get("data")).getValue();
            }
            new XMLFieldMapBuilder(fieldMapName, bgmMap, nodeMap, dataFileReader, textDataPath, this.x, this.y);
        }
        reader.free();
        watch.stop();
        GameLog.printInfo("\u30d5\u30a3\u30fc\u30eb\u30c9\u30de\u30c3\u30d7\u30d3\u30eb\u30c0\u30fc\u304c\u6b63\u5e38\u306b\u8aad\u307f\u8fbc\u307e\u308c\u307e\u3057\u305f(" + watch.getTime() + " ms) : size=[" + this.size() + "]");
        ArrayList list = new ArrayList(this.getAll());
        Collections.sort(list);
        int size2 = list.size();
        for (int i = 0; i < size2; ++i) {
            GameLog.printInfo("- " + ((FieldMapBuilder)list.get(i)).toString());
        }
    }

    private SoundMap createSoundMap(String fieldMapName, List<XMLElement> element) {
        SoundMap soundMap = new SoundMap(fieldMapName);
        if (element == null) {
            return soundMap;
        }
        int size = element.size();
        for (int i = 0; i < size; ++i) {
            XMLAttributeStorage attr = element.get(i).getAttributes();
            String fileName = ((XMLAttribute)attr.get("file")).getValue();
            SoundBuilder builder = new SoundBuilder(fileName);
            builder.setName(attr.contains("name") ? ((XMLAttribute)attr.get("name")).getValue() : StringUtil.fileName(fileName));
            if (attr.contains("loopFrom") && attr.contains("loopTo")) {
                int from = LoopPoint.valueOf(((XMLAttribute)attr.get("loopFrom")).getValue());
                int to = LoopPoint.valueOf(((XMLAttribute)attr.get("loopTo")).getValue());
                builder.setLoopPoint(from, to);
            }
            if (attr.contains("volume")) {
                builder.setMasterGain(((XMLAttribute)attr.get("volume")).getFloatValue());
            }
            soundMap.add(builder.builde());
        }
        return soundMap;
    }

    private NodeMap createNodeMap(List<XMLElement> element) {
        NodeMap nodeMap = new NodeMap();
        if (element == null) {
            return nodeMap;
        }
        int size = element.size();
        for (int i = 0; i < size; ++i) {
            XMLAttributeStorage attr = element.get(i).getAttributes();
            String nodeName = ((XMLAttribute)attr.get("name")).getValue();
            int x = Integer.parseInt(((XMLAttribute)attr.get("x")).getValue());
            int y = Integer.parseInt(((XMLAttribute)attr.get("y")).getValue());
            String mapName = ((XMLAttribute)attr.get("map")).getValue();
            String exitNode = ((XMLAttribute)attr.get("exitNode")).getValue();
            FourDirection face = FourDirection.valueOf(((XMLAttribute)attr.get("face")).getValue());
            String tooltip = ((XMLAttribute)attr.getIfContains("tooltip")).getValue();
            NodeAccepter accepter = attr.contains("accepter") ? (NodeAccepter)NodeAccepterStorage.getInstance().get(((XMLAttribute)attr.get("accepter")).getValue()) : null;
            Node node = new Node(nodeName, new Point(x, y), mapName, exitNode, tooltip, face, accepter);
            nodeMap.put(node.getLocation(), node);
        }
        return nodeMap;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public String toString() {
        return "FieldMapBuilderStorage{x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + '}';
    }
}

