/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import kinugasa.contents.graphics.SerializableImage;
import kinugasa.object.BasicSprite;
import kinugasa.object.ImagePainter;
import kinugasa.object.ImagePainterStorage;
import kinugasa.object.MovingModel;
import kinugasa.object.VectorF;

public class ImageSprite
extends BasicSprite {
    private static final long serialVersionUID = 2943439927664974228L;
    private SerializableImage image;
    private ImagePainter painter;

    public ImageSprite() {
        this.image = null;
        this.painter = ImagePainterStorage.IMAGE_BOUNDS_XY;
    }

    public ImageSprite(float x, float y, float w, float h) {
        super(x, y, w, h);
        this.image = null;
        this.painter = ImagePainterStorage.IMAGE_BOUNDS_XY;
    }

    public ImageSprite(float x, float y, float w, float h, SerializableImage image) {
        super(x, y, w, h);
        this.image = image;
        this.painter = ImagePainterStorage.IMAGE_BOUNDS_XY;
    }

    public ImageSprite(float x, float y, float w, float h, SerializableImage image, ImagePainter model) {
        super(x, y, w, h);
        this.image = image;
        this.painter = model;
    }

    public ImageSprite(float x, float y, float w, float h, VectorF vector, MovingModel mm, SerializableImage image, ImagePainter dm) {
        super(x, y, w, h, vector, mm);
        this.image = image;
        this.painter = dm;
    }

    public ImageSprite(float w, float h, VectorF vector, MovingModel mm, SerializableImage image, ImagePainter dm) {
        super(w, h, vector, mm);
        this.image = image;
        this.painter = dm;
    }

    public ImageSprite(float x, float y, float w, float h, BufferedImage image) {
        super(x, y, w, h);
        this.image = new SerializableImage(image);
        this.painter = ImagePainterStorage.IMAGE_BOUNDS_XY;
    }

    public ImageSprite(float x, float y, float w, float h, BufferedImage image, ImagePainter model) {
        super(x, y, w, h);
        this.image = new SerializableImage(image);
        this.painter = model;
    }

    public ImageSprite(float x, float y, float w, float h, VectorF vector, MovingModel mm, BufferedImage image, ImagePainter dm) {
        super(x, y, w, h, vector, mm);
        this.image = new SerializableImage(image);
        this.painter = dm;
    }

    public ImageSprite(float w, float h, VectorF vector, MovingModel mm, BufferedImage image, ImagePainter dm) {
        super(w, h, vector, mm);
        this.image = new SerializableImage(image);
        this.painter = dm;
    }

    @Override
    public void draw(Graphics2D g) {
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        if (this.image == null) {
            return;
        }
        this.painter.draw(g, this);
    }

    public BufferedImage getImage() {
        return this.image.get();
    }

    public SerializableImage getSerializableImage() {
        return this.image;
    }

    public int getImageWidth() {
        return this.image.getWidth();
    }

    public int getImageHeight() {
        return this.image.getHeight();
    }

    public void setImage(BufferedImage image) {
        this.image = new SerializableImage(image);
    }

    public void setImage(SerializableImage image) {
        this.image = image;
    }

    public ImagePainter getPainter() {
        return this.painter;
    }

    public void setPainter(ImagePainter painter) {
        this.painter = painter;
    }

    @Override
    public ImageSprite clone() {
        ImageSprite sprite = (ImageSprite)super.clone();
        return sprite;
    }

    @Override
    public String toString() {
        return "ImageSprite location=[" + this.getX() + "," + this.getY() + "] size=[" + this.getWidth() + "," + this.getHeight() + "] " + "center=[" + this.getCenterX() + "," + this.getCenterY() + "] personalCenter=[" + this.getPersonalCenterX() + "," + this.getPersonalCenterY() + "] visible=[" + this.isVisible() + "] exist=[" + this.isExist() + "] speed=[" + this.getSpeed() + "] vector=[" + this.getVector() + "] z=[" + this.getZ() + "] image=[" + this.getImage() + "] painter=[" + this.getPainter().getName() + "]";
    }
}

