/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import kinugasa.contents.resource.Storage;
import kinugasa.object.ImagePainter;
import kinugasa.object.ImageSprite;

public final class ImagePainterStorage
extends Storage<ImagePainter> {
    public static final ImagePainter NOT_DRAW = new ImagePainter("NOT_DRAW"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite spr) {
        }
    };
    public static final ImagePainter IMAGE_BOUNDS_XY = new ImagePainter("IMAGE_BOUNDS_XY"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite spr) {
            g.drawImage((Image)spr.getImage(), (int)spr.getX(), (int)spr.getY(), null);
        }
    };
    public static final ImagePainter IMAGE_BOUNDS_CENTER = new ImagePainter("IMAGE_BOUNDS_CENTER"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite spr) {
            g.drawImage((Image)spr.getImage(), (int)(spr.getCenterX() - (float)(spr.getImageWidth() / 2)), (int)(spr.getCenterY() - (float)(spr.getImageHeight() / 2)), null);
        }
    };
    public static final ImagePainter SPRITE_BOUNDS = new ImagePainter("SPRITE_BOUNDS"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite spr) {
            g.drawImage(spr.getImage(), (int)spr.getX(), (int)spr.getY(), (int)spr.getWidth(), (int)spr.getHeight(), null);
        }
    };
    public static final ImagePainter IMAGE_BOUNDS_XY_ROTATE = new ImagePainter("IMAGE_BOUNDS_XY_ROTATE"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite spr) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setClip(spr.getBounds());
            g2.rotate(spr.getVector().getAngleAsRad(), spr.getCenterX(), spr.getCenterY());
            IMAGE_BOUNDS_XY.draw(g2, spr);
            g2.dispose();
        }
    };
    public static final ImagePainter IMAGE_BOUNDS_CENTER_ROTATE = new ImagePainter("IMAGE_BOUNDS_CENTER_ROTATE"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite spr) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setClip(spr.getBounds());
            g2.rotate(spr.getVector().getAngleAsRad(), spr.getCenterX(), spr.getCenterY());
            IMAGE_BOUNDS_CENTER.draw(g2, spr);
            g2.dispose();
        }
    };
    public static final ImagePainter SPRITE_BOUNDS_ROTATE = new ImagePainter("SPRITE_BOUNDS_ROTATE"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite spr) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setClip(spr.getBounds());
            g2.rotate(spr.getVector().getAngleAsRad(), spr.getCenterX(), spr.getCenterY());
            SPRITE_BOUNDS.draw(g2, spr);
            g2.dispose();
        }
    };
    public static final ImagePainter DEBUG_SPRITE_BOUNDS = new ImagePainter("DEBUG_SPRITE_BOUNDS"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite spr) {
            g.setColor(Color.GREEN);
            g.draw(spr.getBounds());
            g.setColor(Color.RED);
            g.draw(spr.getHitBounds());
        }
    };
    public static final ImagePainter TITLING_CPLI_AREA = new ImagePainter("TILING_IMAGE_SIZE"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite sprite) {
            float minX;
            float minY = sprite.getY();
            for (minX = sprite.getX(); minX >= 0.0f; minX -= (float)sprite.getImageWidth()) {
            }
            while (minY >= 0.0f) {
                minY -= (float)sprite.getImageHeight();
            }
            BufferedImage image = sprite.getImage();
            float totalHeight = -minY + (float)g.getClipBounds().height;
            float totalWidth = -minX + (float)g.getClipBounds().width;
            for (float y = minY; y < totalHeight; y += (float)image.getHeight()) {
                for (float x = minX; x < totalWidth; x += (float)image.getWidth()) {
                    g.drawImage((Image)image, (int)x, (int)y, null);
                }
            }
        }
    };
    public static final ImagePainter TILING_SPRITE_SIZE = new ImagePainter("TILING_SPRITE_SIZE"){
        private static final long serialVersionUID = -4287504721301075929L;

        @Override
        public void draw(Graphics2D g, ImageSprite sprite) {
            float minX;
            float minY = sprite.getY();
            for (minX = sprite.getX(); minX >= 0.0f; minX -= (float)sprite.getImageWidth()) {
            }
            while (minY >= 0.0f) {
                minY -= (float)sprite.getImageHeight();
            }
            BufferedImage image = sprite.getImage();
            float totalHeight = -minY + sprite.getHeight();
            float totalWidth = -minX + sprite.getWidth();
            for (float y = minY; y < totalHeight; y += (float)image.getHeight()) {
                for (float x = minX; x < totalWidth; x += (float)image.getWidth()) {
                    g.drawImage((Image)image, (int)x, (int)y, null);
                }
            }
        }
    };
    private static final long serialVersionUID = 2147787454213377482L;
    private static final ImagePainterStorage INSTANCE = new ImagePainterStorage();

    public static ImagePainterStorage getInstance() {
        return INSTANCE;
    }

    private ImagePainterStorage() {
        this.add(NOT_DRAW);
        this.add(IMAGE_BOUNDS_XY);
        this.add(IMAGE_BOUNDS_XY_ROTATE);
        this.add(IMAGE_BOUNDS_CENTER);
        this.add(IMAGE_BOUNDS_CENTER_ROTATE);
        this.add(SPRITE_BOUNDS);
        this.add(SPRITE_BOUNDS_ROTATE);
        this.add(DEBUG_SPRITE_BOUNDS);
        this.add(TILING_SPRITE_SIZE);
        this.add(TITLING_CPLI_AREA);
    }
}

