/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import kinugasa.object.Controllable;
import kinugasa.object.MovingModel;
import kinugasa.object.Sprite;
import kinugasa.object.VectorF;
import kinugasa.object.movingModel.BasicMoving;
import kinugasa.object.movingModel.MovingEvent;

public abstract class BasicSprite
extends Sprite
implements Controllable {
    private static final long serialVersionUID = -6840053657197784234L;
    private VectorF vector;
    private MovingModel moving;

    public BasicSprite() {
        this.vector = new VectorF();
        this.moving = BasicMoving.getInstance();
    }

    public BasicSprite(float x, float y, float w, float h) {
        this(x, y, w, h, new VectorF());
    }

    public BasicSprite(float x, float y, float w, float h, VectorF vector) {
        super(x, y, w, h);
        this.vector = vector;
        this.moving = BasicMoving.getInstance();
    }

    public BasicSprite(float x, float y, float w, float h, VectorF vector, MovingModel model) {
        super(x, y, w, h);
        this.vector = vector;
        this.moving = model;
    }

    public BasicSprite(float w, float h, VectorF vector, MovingModel model) {
        super(0.0f, 0.0f, w, h);
        this.vector = vector;
        this.moving = model;
    }

    public float getAngle() {
        return this.vector.angle;
    }

    public void setAngle(float angle) {
        this.vector.angle = angle;
    }

    public float getSpeed() {
        return this.vector.speed;
    }

    public void setSpeed(float speed) {
        this.vector.speed = speed;
    }

    public void move() {
        this.moving.move(this);
        this.updateCenter();
    }

    public void move(MovingModel m) {
        m.move(this);
        this.updateCenter();
    }

    @Override
    public boolean move(float xValue, float yValue, Shape s) {
        float x = this.getX() + xValue * this.vector.speed;
        float y = this.getY() - yValue * this.vector.speed;
        if (s == null) {
            this.setX(x);
            this.setY(y);
            this.updateCenter();
            return true;
        }
        if (s.contains(new Point2D.Float(x + this.getPersonalCenterX(), y + this.getPersonalCenterY()))) {
            this.setX(x);
            this.setY(y);
            this.updateCenter();
            return true;
        }
        return false;
    }

    @Override
    public boolean move(Point2D.Float p, Shape s) {
        return this.move(p.x, p.y, s);
    }

    @Override
    public abstract void draw(Graphics2D var1);

    public Point2D.Float getNextCenter() {
        Point2D.Float p = (Point2D.Float)this.getCenter().clone();
        p.x += this.vector.getX();
        p.y += this.vector.getY();
        return p;
    }

    public Point2D.Float getNextLocation() {
        Point2D.Float p = this.getLocation();
        p.x += this.vector.getX();
        p.y += this.vector.getY();
        return p;
    }

    public VectorF getVector() {
        return this.vector;
    }

    public void setVector(VectorF vector) {
        this.vector = vector;
    }

    public MovingModel getMovingModel() {
        return this.moving;
    }

    public MovingModel getMovingModel(Class<? extends MovingModel> model) {
        if (this.moving instanceof MovingEvent) {
            MovingEvent me = (MovingEvent)this.moving;
            for (int i = 0; i < me.getModels().length; ++i) {
                if (!model.isInstance(me.getModels()[i])) continue;
                return me.getModels()[i];
            }
            return null;
        }
        return model.isInstance(this.moving) ? this.moving : null;
    }

    public void setMovingModel(MovingModel movingModel) {
        this.moving = movingModel;
    }

    @Override
    public BasicSprite clone() {
        BasicSprite s = (BasicSprite)super.clone();
        s.vector = this.vector.clone();
        s.moving = this.moving.clone();
        return s;
    }

    @Override
    public String toString() {
        return "BasicSprite location=[" + this.getX() + "," + this.getY() + "] size=[" + this.getWidth() + "," + this.getHeight() + "] " + "center=[" + this.getCenterX() + "," + this.getCenterY() + "] personalCenter=[" + this.getPersonalCenterX() + "," + this.getPersonalCenterY() + "] visible=[" + this.isVisible() + "] exist=[" + this.isExist() + "] vector=[" + this.getVector() + "] " + "z=[" + this.getZ() + "]";
    }
}

