/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.Graphics2D;
import kinugasa.contents.graphics.Animation;
import kinugasa.object.ImagePainter;
import kinugasa.object.ImageSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.VectorF;

public class AnimationSprite
extends ImageSprite {
    private static final long serialVersionUID = -7028519961109967679L;
    private Animation animation;
    private boolean imageUpdate = true;

    public AnimationSprite() {
    }

    public AnimationSprite(float x, float y, float w, float h) {
        super(x, y, w, h);
    }

    public AnimationSprite(float x, float y, float w, float h, Animation animation) {
        super(x, y, w, h, animation.getCurrentImage());
        this.animation = animation;
    }

    public AnimationSprite(float x, float y, float w, float h, Animation animation, ImagePainter model) {
        super(x, y, w, h, animation.getCurrentImage(), model);
        this.animation = animation;
    }

    public AnimationSprite(float x, float y, float w, float h, VectorF vector, MovingModel mm, Animation animation, ImagePainter dm) {
        super(x, y, w, h, vector, mm, animation.getCurrentImage(), dm);
        this.animation = animation;
    }

    public AnimationSprite(float w, float h, VectorF vector, MovingModel mm, Animation animation, ImagePainter dm) {
        super(w, h, vector, mm, animation.getCurrentImage(), dm);
        this.animation = animation;
    }

    public AnimationSprite(float w, float h, Animation animation, ImagePainter dm) {
        super(0.0f, 0.0f, w, h, animation.getCurrentImage(), dm);
        this.animation = animation;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public void setImageUpdate(boolean imageUpdate) {
        this.imageUpdate = imageUpdate;
    }

    public boolean isImageUpdate() {
        return this.imageUpdate;
    }

    @Override
    public void update() {
        if (this.animation == null) {
            return;
        }
        this.animation.update();
        this.setImage(this.animation.getCurrentImage());
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (this.imageUpdate & this.isVisible() & this.isExist()) {
            this.update();
        }
    }

    @Override
    public AnimationSprite clone() {
        AnimationSprite result = (AnimationSprite)super.clone();
        if (this.animation != null) {
            result.animation = this.animation.clone();
        }
        return result;
    }

    @Override
    public String toString() {
        return "ImageSprite location=[" + this.getX() + "," + this.getY() + "] size=[" + this.getWidth() + "," + this.getHeight() + "] " + "center=[" + this.getCenterX() + "," + this.getCenterY() + "] personalCenter=[" + this.getPersonalCenterX() + "," + this.getPersonalCenterY() + "] visible=[" + this.isVisible() + "] exist=[" + this.isExist() + "] speed=[" + this.getSpeed() + "] vector=[" + this.getVector() + "] z=[" + this.getZ() + "] image=[" + this.getImage() + "] drawingModel=[" + this.getPainter().getName() + "] animationImage=[" + this.animation + "]";
    }
}

