/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.sound;

import kinugasa.contents.resource.DynamicStorage;
import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.sound.CachedSound;
import kinugasa.contents.sound.Sound;
import kinugasa.contents.sound.SoundBuilder;
import kinugasa.contents.sound.SoundStorage;

public final class SoundMap
extends DynamicStorage<Sound>
implements Freeable,
Nameable {
    private String name;
    private static int counter;

    public SoundMap() {
        this("SoundMap_" + counter++);
    }

    public SoundMap(String name, Sound ... sounds) {
        this(name);
        this.addAll(sounds);
    }

    public SoundMap(String name) {
        this.name = name;
        this.setStorage();
    }

    private void setStorage() {
        SoundStorage.getInstance().add(this);
    }

    public CachedSound createCachedSound(SoundBuilder soundBuilder) {
        CachedSound sound = soundBuilder.builde();
        this.add(sound);
        return sound;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void dispose() {
        this.free();
        SoundStorage.getInstance().remove(this);
    }

    public void setVolume(float vol) {
        for (Sound sound : this) {
            sound.setVolume(vol);
        }
    }

    public void stopAll() {
        for (Sound sound : this) {
            sound.stop();
        }
    }
}

