/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.saveData;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.saveData.ContentsIO;

public abstract class SaveData
implements Nameable,
Serializable {
    private static final long serialVersionUID = 5051478173983169607L;
    private String name;
    private long createTime;
    private Date date;

    public SaveData() {
        this("");
    }

    public SaveData(String name) {
        this.name = name;
        this.createTime = System.currentTimeMillis();
        this.date = new Date();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date date) {
        this.date = date;
    }

    public final long getCreateTime() {
        return this.createTime;
    }

    public final void save(File file) throws ContentsFileNotFoundException, ContentsIOException {
        ContentsIO.save(this, file);
    }

    public static SaveData load(File file) throws ContentsFileNotFoundException, ContentsIOException {
        return ContentsIO.load(SaveData.class, file);
    }

    public static List<SaveData> loadAll(File dir) throws ContentsFileNotFoundException, ContentsIOException, IllegalArgumentException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir is not directory");
        }
        File[] files = dir.listFiles();
        ArrayList<SaveData> result = new ArrayList<SaveData>(files.length);
        for (File file : files) {
            if (file.isDirectory()) {
                result.addAll(SaveData.loadAll(file));
                continue;
            }
            try {
                result.add(ContentsIO.load(SaveData.class, file));
            }
            catch (ContentsFileNotFoundException ex) {
            }
            catch (ContentsIOException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public String toString() {
        return "SaveData{name=" + this.name + ", createTime=" + this.createTime + ", date=" + this.date + '}';
    }
}

