/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.saveData;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import kinugasa.contents.resource.ContentsFileNotFoundException;
import kinugasa.contents.resource.ContentsIOException;
import kinugasa.game.GameLog;

public final class ContentsIO {
    private ContentsIO() {
    }

    public static <T extends Serializable> void save(T obj, String filePath) throws ContentsFileNotFoundException, ContentsIOException {
        ContentsIO.save(obj, new File(filePath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> void save(T obj, File file) throws ContentsFileNotFoundException, ContentsIOException {
        ObjectOutputStream stream = null;
        try {
            stream = new ObjectOutputStream(new FileOutputStream(file));
            stream.writeObject(obj);
            return;
        }
        catch (FileNotFoundException ex) {
            throw new ContentsFileNotFoundException(ex);
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new ContentsIOException(ex);
            }
            finally {
                GameLog.printInfoIfUsing("> ContentsIO : save : obj=[" + obj + "] file=[" + file.getPath() + "]");
            }
        }
    }

    public static <T extends Serializable> T load(Class<T> type, String filePath) throws ContentsFileNotFoundException, ContentsIOException {
        return ContentsIO.load(type, new File(filePath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T load(Class<T> type, File file) throws ContentsFileNotFoundException, ContentsIOException {
        ObjectInputStream stream = null;
        try {
            stream = new ObjectInputStream(new FileInputStream(file));
            Serializable serializable = (Serializable)type.cast(stream.readObject());
            return (T)serializable;
        }
        catch (FileNotFoundException ex) {
            throw new ContentsFileNotFoundException(ex);
        }
        catch (IOException ex) {
            throw new ContentsIOException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ContentsIOException(ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                throw new ContentsIOException(ex);
            }
            finally {
                GameLog.printInfoIfUsing("> ContentsIO : load : type=[" + type + "] file=[" + file.getPath() + "]");
            }
        }
    }
}

