/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.resource;

import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.Loadable;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.Nameable;
import kinugasa.contents.resource.Storage;
import kinugasa.util.ArrayUtil;

public abstract class DynamicStorage<T extends Nameable & Freeable>
extends Storage<T>
implements Freeable,
Loadable {
    public DynamicStorage(int initialSize) {
        super(initialSize);
    }

    public DynamicStorage() {
    }

    @Override
    public DynamicStorage<T> load() {
        for (Nameable obj : this) {
            ((Loadable)((Object)obj)).load();
        }
        return this;
    }

    public T load(String name) throws NameNotFoundException {
        Object obj = this.get(name);
        ((Loadable)obj).load();
        return obj;
    }

    @Override
    public DynamicStorage<T> free() {
        for (Nameable obj : this) {
            ((Freeable)((Object)obj)).free();
        }
        return this;
    }

    public T free(String name) throws NameNotFoundException {
        Object obj = this.get(name);
        ((Freeable)obj).free();
        return obj;
    }

    public void loadAll(String ... names) {
        for (Nameable obj : this) {
            if (!ArrayUtil.contains(names, obj.getName())) continue;
            ((Loadable)((Object)obj)).load();
        }
    }

    public void freeAll(String ... names) {
        for (Nameable obj : this) {
            if (!ArrayUtil.contains(names, obj.getName())) continue;
            ((Freeable)((Object)obj)).free();
        }
    }

    public void exFree(String ... names) {
        for (Nameable obj : this) {
            if (ArrayUtil.contains(names, obj.getName())) continue;
            ((Freeable)((Object)obj)).free();
        }
    }

    @Override
    public boolean isLoaded() {
        for (Nameable obj : this) {
            if (!((Loadable)((Object)obj)).isLoaded()) continue;
            return true;
        }
        return false;
    }

    public boolean isLoadedAll() {
        for (Nameable obj : this) {
            if (((Loadable)((Object)obj)).isLoaded()) continue;
            return false;
        }
        return true;
    }

    public boolean isLoaded(String name) throws NameNotFoundException {
        return ((Loadable)this.get(name)).isLoaded();
    }
}

