/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.graphics;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kinugasa.contents.graphics.ImageEditor;
import kinugasa.contents.graphics.ImageUtil;
import kinugasa.contents.graphics.SpriteSheetCutter;
import kinugasa.game.GameLog;

public class SpriteSheet {
    private BufferedImage baseImage;
    private ArrayList<BufferedImage> subImages;

    public SpriteSheet() {
        this.subImages = new ArrayList(32);
    }

    public SpriteSheet(String filePath) {
        this.baseImage = ImageUtil.load(filePath);
        this.subImages = new ArrayList(32);
    }

    public SpriteSheet(BufferedImage baseImage) {
        this.baseImage = baseImage;
        this.subImages = new ArrayList(32);
    }

    public SpriteSheet cut(int x, int y, int width, int height) throws RasterFormatException {
        this.subImages.add(this.baseImage.getSubimage(x, y, width, height));
        return this;
    }

    public SpriteSheet cut(Rectangle rectangle) throws RasterFormatException {
        return this.cut(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public SpriteSheet resizeAll(float scale) {
        BufferedImage[] result = ImageEditor.resizeAll(this.subImages.toArray(new BufferedImage[this.subImages.size()]), scale);
        this.subImages.clear();
        this.addAll(result);
        return this;
    }

    public SpriteSheet cut(SpriteSheetCutter cutter) throws RasterFormatException {
        this.addAll(cutter.cut(this.baseImage));
        return this;
    }

    public SpriteSheet split(int width, int height) throws RasterFormatException {
        BufferedImage[][] images;
        for (BufferedImage[] line : images = ImageUtil.splitAsArray(this.baseImage, width, height)) {
            this.subImages.addAll(Arrays.asList(line));
        }
        return this;
    }

    public SpriteSheet rows(int y, int width, int height) throws RasterFormatException {
        this.subImages.addAll(Arrays.asList(ImageUtil.rows(this.baseImage, y, width, height)));
        return this;
    }

    public SpriteSheet columns(int x, int width, int height) throws RasterFormatException {
        this.subImages.addAll(Arrays.asList(ImageUtil.columns(this.baseImage, x, width, height)));
        return this;
    }

    public SpriteSheet add(BufferedImage image) {
        this.subImages.add(image);
        return this;
    }

    public SpriteSheet addAll(BufferedImage ... images) {
        this.subImages.addAll(Arrays.asList(images));
        return this;
    }

    public SpriteSheet baseImage() {
        this.subImages.add(this.baseImage);
        return this;
    }

    public BufferedImage[] images() {
        int nullIdx;
        GameLog.printInfo("SpriteSheet\u304c\u5207\u308a\u51fa\u3055\u308c\u307e\u3057\u305f : size=[" + this.subImages.size() + "]");
        this.subImages.trimToSize();
        int size = this.subImages.size();
        for (nullIdx = 0; nullIdx < size && this.subImages.get(nullIdx) != null; ++nullIdx) {
        }
        BufferedImage[] result = new BufferedImage[nullIdx];
        System.arraycopy(this.subImages.toArray(new BufferedImage[this.subImages.size()]), 0, result, 0, nullIdx);
        return result;
    }

    public Map<String, BufferedImage> toMap() {
        HashMap<String, BufferedImage> result = new HashMap<String, BufferedImage>(this.subImages.size());
        int size = this.subImages.size();
        for (int i = 0; i < size; ++i) {
            result.put(Integer.toString(i), this.subImages.get(i));
        }
        return result;
    }

    public String toString() {
        return "SpriteSheet{baseImage=" + this.baseImage + ", subImages=" + this.subImages + '}';
    }
}

