/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.graphics;

import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import kinugasa.game.GameLog;

public final class GraphicsUtil {
    private GraphicsUtil() {
    }

    public static void useOpenGL() {
        System.setProperty("sun.java2d.opengl", "true");
        GameLog.printInfoIfUsing("> opengl state : [" + System.getProperty("sun.java2d.opengl") + "]");
    }

    public static boolean isUseOpenGL() {
        return System.getProperty("sun.java2d.opengl").equals("true");
    }

    public static void clearRect(Graphics g, Rectangle2D r) {
        g.clearRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static void drawRect(Graphics g, Rectangle2D r) {
        g.drawRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static void fillRect(Graphics g, Rectangle2D r) {
        g.fillRect((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static void drawOval(Graphics g, Rectangle2D r) {
        g.drawOval((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static void fillOval(Graphics g, Rectangle2D r) {
        g.fillOval((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }
}

