/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import kinugasa.contents.event.Event;
import kinugasa.contents.event.EventManager;
import kinugasa.contents.resource.NameNotFoundException;
import kinugasa.contents.resource.NotYetLoadedException;
import kinugasa.game.GameLog;

public abstract class MultiClassEventManager
extends EventManager {
    private static final long serialVersionUID = 5774295111597602465L;
    private List<Event<?>> events;

    public MultiClassEventManager() {
        this(32);
    }

    public MultiClassEventManager(int initialSize) {
        this.events = new ArrayList(initialSize);
    }

    @Override
    protected abstract void init();

    @Override
    public MultiClassEventManager load() {
        return (MultiClassEventManager)super.load();
    }

    @Override
    public MultiClassEventManager free() {
        return (MultiClassEventManager)super.free();
    }

    @Override
    public void printAll() {
        int size = this.events.size();
        for (int i = 0; i < size; ++i) {
            GameLog.printInfo("-" + this.events.get(i));
        }
    }

    @Override
    public void sort() {
        Collections.sort(this.events);
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public void clear() {
        this.events.clear();
    }

    @Override
    public boolean contains(Event<?> evt) {
        return this.events.contains(evt);
    }

    @Override
    public void remove(Event<?> evt) {
        this.events.remove(evt);
    }

    @Override
    public void removeAll(Event<?> ... evt) {
        this.events.removeAll(Arrays.asList(evt));
    }

    public final void add(Event<?> e) {
        this.events.add(e);
    }

    public final void addAll(Event<?> ... e) {
        this.events.addAll(Arrays.asList(e));
    }

    public final <T extends Serializable> Event<T> getNext(Class<T> type) throws NotYetLoadedException, NameNotFoundException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        int size = this.events.size();
        for (int i = 0; i < size; ++i) {
            if (!this.events.get(i).getType().equals(type) && !type.isInstance(this.events.get(i).getObject())) continue;
            return this.events.get(i);
        }
        throw new NameNotFoundException("not found : type=[" + type.getName() + "]");
    }

    public final <T> boolean hasNext(Class<T> type) throws NotYetLoadedException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        int size = this.events.size();
        for (int i = 0; i < size; ++i) {
            Event<?> evt = this.events.get(i);
            if (!evt.getType().equals(type) && !type.isInstance(evt.getObject()) || !evt.isReaching()) continue;
            return true;
        }
        return false;
    }

    public final <T extends Serializable> T execute(Class<T> type) throws NotYetLoadedException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        if (!this.hasNext(type)) {
            return null;
        }
        Event<T> evt = this.getNext(type);
        GameLog.printIfUsing(Level.INFO, "> MultiClassEventManager : execute : now=[" + this.getProgressTime() + "] event=[" + evt + "]");
        this.remove(evt);
        return (T)((Serializable)evt.execute());
    }

    public List<Event<?>> getEvents() {
        return this.events;
    }

    @Override
    public String toString() {
        return "> MultiClassEventManager{load=" + this.isLoaded() + ", events=" + this.size() + ", progressTime=" + this.getProgressTime() + '}';
    }
}

