/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.contents.event;

import java.io.Serializable;
import kinugasa.contents.event.EntryModel;
import kinugasa.contents.event.Event;
import kinugasa.contents.resource.Freeable;
import kinugasa.contents.resource.Loadable;
import kinugasa.game.GameLog;

public abstract class EventManager
implements Freeable,
Loadable,
Serializable {
    private static final long serialVersionUID = -1656169201397066551L;
    private transient long progressTime = 0L;
    private transient boolean load = false;
    protected final EntryModel TIME_BASE_ENTRY_MODEL = new EntryModel(){
        private static final long serialVersionUID = -3986406384609892814L;

        @Override
        public boolean isReaching(Event<?> evt) {
            return evt.getExecuteTime() > EventManager.this.getProgressTime();
        }
    };

    public void update() {
        ++this.progressTime;
    }

    public long getProgressTime() {
        return this.progressTime;
    }

    @Override
    public EventManager load() {
        this.init();
        this.sort();
        if (GameLog.isUsingLog()) {
            GameLog.printInfo("EventManager\u306e\u30ed\u30fc\u30c9\u304c\u958b\u59cb\u3057\u305f");
            this.printAll();
            GameLog.printInfo("EventManager\u306e\u30ed\u30fc\u30c9\u304c\u5b8c\u4e86\u3057\u305f");
        }
        this.load = true;
        return this;
    }

    protected abstract void init();

    @Override
    public EventManager free() {
        this.progressTime = 0L;
        this.clear();
        this.load = false;
        return this;
    }

    public abstract void printAll();

    @Override
    public boolean isLoaded() {
        return this.load;
    }

    public abstract void sort();

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract void clear();

    public abstract boolean contains(Event<?> var1);

    public abstract void remove(Event<?> var1);

    public abstract void removeAll(Event<?> ... var1);

    public String toString() {
        return "EventManager{progressTime=" + this.progressTime + ", load=" + this.load + '}';
    }
}

