/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <qmessagebox.h>
#include <qregexp.h>


void PropertyForm::show()
{
  _cmbstartkey->setCurrentText(Config::readEntry(_cmbstartkey->name(),
						 _cmbstartkey->currentText()));
  _cmbinputmode->setCurrentText(Config::readEntry(_cmbinputmode->name(), 
						  _cmbinputmode->currentText()));
  _cmbinputmethod->setCurrentText(Config::readEntry(_cmbinputmethod->name(), 
						  _cmbinputmethod->currentText()));
  
  _cmbspacekey->setCurrentText(Config::readEntry(_cmbspacekey->name(),
						 _cmbspacekey->currentText()));
  _cmbtenkey->setCurrentText(Config::readEntry(_cmbtenkey->name(), 
					       _cmbtenkey->currentText()));
  _cmbkuten->setCurrentText(Config::readEntry(_cmbkuten->name(), 
					      _cmbkuten->currentText()));
  _cmbtouten->setCurrentText(Config::readEntry(_cmbtouten->name(), 
						_cmbtouten->currentText()));
  _cmbsymbol->setCurrentText(Config::readEntry(_cmbsymbol->name(), 
					       _cmbsymbol->currentText()));
  _cmbbracket->setCurrentText(Config::readEntry(_cmbbracket->name(), 
						_cmbbracket->currentText()));

  _cmbkanjisys->setCurrentText(Config::readEntry(_cmbkanjisys->name(), 
						 _cmbkanjisys->currentText()));
  _chkremote->setChecked(Config::readBoolEntry(_chkremote->name(), 
					       _chkremote->isChecked()));
  _edtsvrname->setText(Config::readEntry(_edtsvrname->name(), _edtsvrname->text()));
  _edtport->setText(Config::readEntry(_edtport->name(), _edtport->text()));
  
  QWidget::show();
}


void PropertyForm::clickedOkBtn()
{
  // Check entry
  if (_chkremote->isChecked()) {
    if (_edtsvrname->text().isEmpty() || _edtport->text().isEmpty()) {
      QMessageBox::warning(0, "Incorrect entry", 
			   "Incorrect entry!\nInput Kanji server and port correctly.",
			   QMessageBox::Ok | QMessageBox::Default, 0);

      _tabwdg->showPage(_tab3);  // show page
      return;
      
    } else if ( !_edtport->text().contains(QRegExp("^[0-9]{4,5}$")) ) {
      QMessageBox::warning(0, "Incorrect port number", 
			   "Incorrect port number!\nInput numerical string, 4 or 5 characters.",
			   QMessageBox::Ok | QMessageBox::Default, 0);
      
      _tabwdg->showPage(_tab3);  // show page
      return;
    }
  }
  
  Config::writeEntry(_cmbstartkey->name(), _cmbstartkey->currentText());
  Config::writeEntry(_cmbinputmode->name(), _cmbinputmode->currentText());
  Config::writeEntry(_cmbinputmethod->name(), _cmbinputmethod->currentText());

  Config::writeEntry(_cmbspacekey->name(), _cmbspacekey->currentText());
  Config::writeEntry(_cmbtenkey->name(), _cmbtenkey->currentText());
  Config::writeEntry(_cmbkuten->name(), _cmbkuten->currentText());
  Config::writeEntry(_cmbtouten->name(), _cmbtouten->currentText());
  Config::writeEntry(_cmbsymbol->name(), _cmbsymbol->currentText());
  Config::writeEntry(_cmbbracket->name(), _cmbbracket->currentText());
  
  Config::writeEntry(_cmbkanjisys->name(), _cmbkanjisys->currentText());
  Config::writeEntry(_chkremote->name(), _chkremote->isChecked());
  Config::writeEntry(_edtsvrname->name(), _edtsvrname->text());
  Config::writeEntry(_edtport->name(), _edtport->text());
  
  close();
  
  MainForm* parent = (MainForm*)parentWidget();
  if (parent) parent->initIM();   // Re-initialize to connect Kanji server
}


void PropertyForm::init()
{
  QToolTip::add(_tab1, tr("ΥڡϼεưȿǤޤ"));
  QToolTip::add(_lblstartkey, tr("Ϥ򳫻Ϥ뤿Υꤷޤ"));
  QToolTip::add(_cmbstartkey, tr("Ϥ򳫻Ϥ뤿Υꤷޤ"));
  QToolTip::add(_lblinputmode, tr("Kimeraưϥ⡼ɤꤷޤ"));
  QToolTip::add(_cmbinputmode, tr("Kimeraưϥ⡼ɤꤷޤ"));
  QToolTip::add(_lblinputmethod, tr("KimeraưȤơ\n޻ϤޤϤϤꤷޤ"));
  QToolTip::add(_cmbinputmethod, tr("KimeraưȤơ\n޻ϤޤϤϤꤷޤ"));

  QToolTip::add(_lblspacekey, tr("ڡ򲡤ζʸˤĤ\nȾѤޤѤꤷޤ"));
  QToolTip::add(_cmbspacekey, tr("ڡ򲡤ζʸˤĤ\nȾѤޤѤꤷޤ"));
  QToolTip::add(_lbltenkey, tr("ƥ󥭡ϤʸˤĤ\nȾѤޤѤꤷޤ"));
  QToolTip::add(_cmbtenkey, tr("ƥ󥭡ϤʸˤĤ\nȾѤޤѤꤷޤ"));
  QToolTip::add(_lbltouten, tr("ꤷޤ"));
  QToolTip::add(_cmbtouten, tr("ꤷޤ"));
  QToolTip::add(_lblkuten, tr("ʸꤷޤ"));
  QToolTip::add(_cmbkuten, tr("ʸꤷޤ"));
  QToolTip::add(_lblbracket, tr("̤ꤷޤ"));
  QToolTip::add(_cmbbracket, tr("̤ꤷޤ"));
  QToolTip::add(_lblsymbol, tr("ꤷޤ"));
  QToolTip::add(_cmbsymbol, tr("ꤷޤ"));

  QToolTip::add(_lblkanjisys, tr("ѤѴƥꤷޤ"));
  QToolTip::add(_cmbkanjisys, tr("ѤѴƥꤷޤ"));
  QToolTip::add(_lblsvrname, tr("ѴФΥۥ̾ꤷޤ"));
  QToolTip::add(_edtsvrname, tr("ѴФΥۥ̾ꤷޤ"));
  QToolTip::add(_lblport, tr("³ݡֹꤷޤ"));
  QToolTip::add(_edtport, tr("³ݡֹꤷޤ"));
}
