#ifndef XIMETHOD_H
#define XIMETHOD_H

#include "ximattribute.h"
#include "supportattr.h"
#include <qvaluelist.h>
#include <qintdict.h>
#include <X11/Xlib.h>

class XIMethod {
public:
  XIMethod();
  ~XIMethod() { }

  void       connectIM(Window w, QDataStream::ByteOrder b); 
  void       disconnectIM();
  ushort     createIM(Window w);
  void       removeIM(ushort im);
  ushort     createXIC(ushort im);
  void       removeXIC(ushort im, ushort ic);
  void       setICValue(ushort im, ushort ic, ushort id, const QByteArray&);
  QByteArray getICValue(ushort im, ushort ic, ushort id);
  QString    fontPreedit(ushort im, ushort ic);
  QPoint     spotPreedit(ushort im, ushort ic);
  Window     commWin(ushort im) const;
  Window     focusWindow(ushort im, ushort ic) const;
  void       setTriggerFlag(ushort im, ushort ic, bool b);
  bool       triggerFlag(ushort im, ushort ic) const;
  QByteArray getInputStyle(ushort im) const;
  QDataStream::ByteOrder byteOrder(ushort im) const;

  static QValueList<SupportAttr>  getSuppIMAttr();
  static QValueList<SupportAttr>  getSuppICAttr();

protected:
  void         setInputStyle(ushort im, const QByteArray& data);
  XIMAttribute*     takeIMAttr(ushort im) const;
  static void  initSuppIMAttr();   // initialize IM attributes supported

private:
  QIntDict<XIMAttribute>   _imlist;   // list of IM
  static QValueList<SupportAttr>  _attr_list; // IM attributes supported
};


#endif // XIMETHOD_H

