#include "preeditarea.h"
#include <qrect.h>
#include <qmessagebox.h>


PreeditArea::PreeditArea() : 
  QLabel((QWidget*)0, "preedit", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM),
  _normal_fgclr(QColor("blue")),
  _normal_bgclr(QColor("gainsboro")),
  _attention_fgclr(QColor("black")),
  _attention_bgclr(QColor("cyan")),
  _changing_fgcolr(QColor("white")),
  _changing_bgcolr(QColor("blue"))
{
  _otherphases = new QLabel((QWidget*)0, "preedit2", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM);
}


PreeditArea::~PreeditArea() { }


void 
PreeditArea::setFont(const QFont & f)
{
  QLabel::setFont(f);
  QLabel::setMargin( 1 );
  QLabel::setIndent( 0 );
  QLabel::setAutoMask( FALSE );
  QLabel::setFrameStyle( QFrame::Plain | QFrame::Box );
  QLabel::setLineWidth( 0 );
  QLabel::setAlignment( AlignAuto | AlignTop );

  _otherphases->setFont(f);
  _otherphases->setMargin( 1 );
  _otherphases->setIndent( 0 );
  _otherphases->setAutoMask( FALSE );
  _otherphases->setFrameStyle( QFrame::Plain | QFrame::Box );
  _otherphases->setLineWidth( 0 );
  _otherphases->setAlignment( AlignAuto | AlignTop );
}


void
PreeditArea::showText(const QPoint& pos, const QStringList& strlist)
{
  int offset;
  if ((offset = font().pixelSize()) < 0) {
    offset = font().pointSize();
  }

  QStringList sl = strlist;
  // Ѵʸ
  if ( !sl.isEmpty() ) {
    setText(sl.first());
    sl.pop_front();
  }
 
  // Ѵʸɽ
  if ( ! text().isEmpty() ) {
    setGeometry(QRect(pos - QPoint(0, offset), sizeHint()));  
    show();
    qDebug("show text: %s", text().local8Bit().data());
  } else {
    hide();
  }

  // ѴԤʸ
  if ( !sl.isEmpty() ) {
    _otherphases->setText(sl.join(""));
  }

  // ѴԤʸɽ
  if ( ! _otherphases->text().isEmpty() ) {
    _otherphases->setGeometry(QRect(pos - QPoint(0, offset) + QPoint(size().width(), 0), _otherphases->sizeHint()));
    _otherphases->show();
  } else {
    _otherphases->hide();
  }
}


void
PreeditArea::hide()
{
  QLabel::hide();
  QLabel::clear();
  _otherphases->hide();
  _otherphases->clear();
}


void 
PreeditArea::showInputingString(const QPoint& p, const QString& str)
{
  setPaletteForegroundColor( _normal_fgclr );
  setPaletteBackgroundColor( _normal_bgclr );
  
  showText(p, QStringList(str));
}


void 
PreeditArea::showConvertingPhases(const QPoint& p, const QStringList& strlist)
{
  setPaletteForegroundColor( _attention_fgclr );
  setPaletteBackgroundColor( _attention_bgclr );
  _otherphases->setPaletteForegroundColor( _normal_fgclr );
  _otherphases->setPaletteBackgroundColor( _normal_bgclr);
  
  showText(p, strlist);
}


void 
PreeditArea::showChangingPhaseLength(const QPoint& p, const QStringList& strlist)
{
  setPaletteForegroundColor( _changing_fgcolr);
  setPaletteBackgroundColor( _changing_bgcolr);
  _otherphases->setPaletteForegroundColor( _normal_fgclr );
  _otherphases->setPaletteBackgroundColor( _normal_bgclr);
  
  showText(p, strlist);
}
