#ifndef XICATTRIBUTE_H
#define XICATTRIBUTE_H

#include <qstring.h>
#include <qvaluelist.h>
#include <qpoint.h>
#include <X11/Xlib.h>

class XICAttribute {
public:
  XICAttribute(ushort ic, QDataStream::ByteOrder bo);
  ~XICAttribute();

  inline ushort  ic() const { return _icid; }
  void           setValue(ushort, const QByteArray&); 
  QByteArray     getValue(ushort) const;
  inline void    setTriggerFlag(bool b) { _trgr_flag = b; }
  inline bool    triggerFlag() const { return _trgr_flag; }
  inline Window  focusWindow() const { return _focuswin ? _focuswin : _clientwin; }
  inline QString fontPreedit() const { return _fontset_pree; }
  inline QPoint  spotPreedit() const { return QPoint(_spot_pree.x, _spot_pree.y); }

protected:
  void setValuePreeditAttr(ushort, const QByteArray&);
  void setValueStatusAttr(ushort, const QByteArray&);
  inline int pad(int n) const { return (4 - (n % 4)) % 4; }

private:
  ushort   _icid;
  bool     _trgr_flag;  // trigger flag   TRUE:on-key  FALSE:off-key 
  QDataStream::ByteOrder  _byteorder;
 
  Window      _clientwin;    // attribute ID: 1
  ulong       _filterevents; // attribute ID: 4
  Window      _focuswin;     // attribute ID: 5

  // Preedit Attributes      // attribute ID: 2
  QString     _fontset_pree; // attribute ID: 6
  XPoint      _spot_pree;    // attribute ID: 7
  XRectangle  _areand_pree;  // attribute ID: 8
  XRectangle  _area_pree;    // attribute ID: 9
  ulong       _fg_pree;      // attribute ID: 10
  ulong       _bg_pree;      // attribute ID: 11
  Pixmap      _bgpix_pree;   // attribute ID: 12
  Colormap    _color_pree;   // attribute ID: 13
  Atom        _stdclr_pree;  // attribute ID: 14
  int         _line_pree;    // attribute ID: 15
  Cursor      _cur_pree;     // attribute ID: 16

  // Status Attributes       // attribute ID: 3
  QString     _fontset_stat; // attribute ID: 6
  XPoint      _spot_stat;    // attribute ID: 7
  XRectangle  _areand_stat;  // attribute ID: 8
  XRectangle  _area_stat;    // attribute ID: 9
  ulong       _fg_stat;      // attribute ID: 10
  ulong       _bg_stat;      // attribute ID: 11
  Pixmap      _bgpix_stat;   // attribute ID: 12
  Colormap    _color_stat;   // attribute ID: 13
  Atom        _stdclr_stat;  // attribute ID: 14
  int         _line_stat;    // attribute ID: 15
  Cursor      _cur_stat;     // attribute ID: 16
};


#endif // XICATTRIBUTE_H

