#ifndef SOCKKANJICLIENT_H
#define SOCKKANJICLIENT_H

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>

class QSocket;

class SockKanjiClient : public QObject {
  Q_OBJECT

public:
  SockKanjiClient();
  ~SockKanjiClient();

  void init();
  void beginConvert(const QString&);
  void endConvert();
  void getCandidacyList(short);
  void getYomi(short);
  void resizePause(short, short);
  inline bool isConverting() const { return _convertflag; }

signals:
  void allPhasesConvt(const QStringList&);
  void reconvtPhases(const QStringList&);
  void candidacyList(const QStringList&);
  void currentYomi(const QString&);

protected:
  void sendInitialize();
  void mountDictionary();
  void getDictionaryList();
  void recvGetDictionaryListReply();
  void recvMountDictionaryReply(); 
  void recvBeginConvertReply();
  void recvEndConvertReply() const;
  void recvGetCandidacyListReply();
  void recvGetYomiReply();
  void recvResizePause();

  QByteArray  eucToUshort(const QCString&);
  QCString    ushortToEuc(const QByteArray&);

protected slots:
  void slotConnected();
  void slotInitializeReply();
  void slotDispatch();
  void slotDetectError();
  void slotConnectionClosed();

private:
  QSocket* _sock;
  short    _contxt;
  short    _nbunsetu;
  bool     _convertflag;   // TRUE:  conversion in progress
                           // FALSE: conversion done
  QStringList _diclist;    // to mount dictionary
};

#endif // SOCKKANJICLIENT_H





