#ifndef MAINFORM_H
#define MAINFORM_H

#include "kimeraapp.h"
#include "kanjiconvert.h"
#include <qvariant.h>
#include <qwidget.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QToolButton;
class QPopupMenu;
class InputMethod;
class InputMode;

class MainForm : public QWidget
{ 
  Q_OBJECT
  
public:
  MainForm( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~MainForm();

signals:
  void setInputMode(const InputMode&);

public slots:
  void slotTriggerNotify(bool);
  void polish();

protected slots:
  void setModeHira();
  void setModeKata();
  void setModeZenkakuEisu();
  void setModeRomaInput();
  void setModeKanaInput();

private:
  QToolButton* _toolbutton1;
  QToolButton* _toolbutton2;
  QToolButton* _toolbutton3;
  QPopupMenu*  _popupmenu1;
  QPopupMenu*  _popupmenu2;
  InputMethod* _inputmethod;
};

#endif // MAINFORM_H
