#include "mainform.h"
#include "kimeraapp.h"
#include "inputmethod.h"
#include "inputmode.h"
#include <qvariant.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qpopupmenu.h> 
#include <qstring.h> 


MainForm::MainForm( QWidget* parent, const char* name, WFlags fl )
  : QWidget(parent, name, fl)
{
  if ( !name ) setName( "MainForm" );
  resize(90, 30); 
  setCaption( trUtf8( "MainForm" ) );
  
  _toolbutton1 = new QToolButton( this, "ToolButton1" );
  _toolbutton1->setGeometry( QRect( 0, 0, 31, 31 ) ); 
  _toolbutton1->setTextLabel(QString("A_"));
  _toolbutton1->setUsesTextLabel(TRUE);

  _toolbutton2 = new QToolButton( this, "ToolButton2" );
  _toolbutton2->setGeometry( QRect( 30, 0, 31, 31 ) ); 
  _toolbutton2->setTextLabel("Roma");
  _toolbutton2->setUsesTextLabel(TRUE);
  QFont f =_toolbutton2->font();
  f.setPointSize( 8 );
  _toolbutton2->setFont(f);
  
  _toolbutton3 = new QToolButton( this, "ToolButton3" );
  _toolbutton3->setGeometry( QRect( 60, 0, 31, 31 ) ); 
  _toolbutton3->setText( trUtf8( "..." ) );

  _popupmenu1 = new QPopupMenu();
  _popupmenu1->insertItem(tr("Ҥ餬"), this, SLOT(setModeHira()), 0, InputMode::Hiragana);
  _popupmenu1->insertItem(tr(""), this, SLOT(setModeKata()), 0, InputMode::Katakana);
  _popupmenu1->insertItem(tr("ѱѿ"), this, SLOT(setModeZenkakuEisu()), 0, InputMode::ZenkakuEisu);
  _popupmenu1->setItemEnabled(InputMode::Hiragana, FALSE);
  _popupmenu1->setItemEnabled(InputMode::Katakana, FALSE);
  _popupmenu1->setItemEnabled(InputMode::ZenkakuEisu, FALSE);

  _toolbutton1->setPopup(_popupmenu1);
  _toolbutton1->setPopupDelay(1);

  _popupmenu2 = new QPopupMenu();
  _popupmenu2->insertItem(tr("޻"), this, SLOT(setModeRomaInput()), 0, InputMode::RomaInput);
  _popupmenu2->insertItem(tr(""), this, SLOT(setModeKanaInput()), 0, InputMode::KanaInput);
  _popupmenu2->setItemEnabled(InputMode::RomaInput, FALSE);
  _popupmenu2->setItemEnabled(InputMode::KanaInput, FALSE);

  _toolbutton2->setPopup(_popupmenu2);
  _toolbutton2->setPopupDelay(1);

  _inputmethod = KimeraApp::inputmethod();
  connect(_inputmethod, SIGNAL(triggerNotify(bool)), 
	  this, SLOT(slotTriggerNotify(bool)));

  // Transfer signal to signal
  connect(this, SIGNAL(setInputMode(const InputMode&)), 
	  _inputmethod, SIGNAL(setInputMode(const InputMode&)));
}


MainForm::~MainForm()
{
  // no need to delete child widgets, Qt does it all for us
  
  delete _toolbutton1;
  delete _toolbutton2;
  delete _toolbutton3;
  delete _popupmenu1;
  delete _popupmenu2;
}

void
MainForm::polish()
{
  QWidget::polish();
  _inputmethod->init();
}


void
MainForm::setModeHira()
{
  _toolbutton1->setTextLabel(tr(""));
  emit setInputMode(InputMode(InputMode::Hiragana));
}


void
MainForm::setModeKata()
{
  _toolbutton1->setTextLabel(tr(""));
  emit setInputMode(InputMode(InputMode::Katakana));
}


void
MainForm::setModeZenkakuEisu()
{
  _toolbutton1->setTextLabel(tr(""));
  emit setInputMode(InputMode(InputMode::ZenkakuEisu));
}


void
MainForm::setModeRomaInput()
{
  _toolbutton2->setTextLabel("Roma");
  emit setInputMode(InputMode(InputMode::RomaInput));
}


void
MainForm::setModeKanaInput()
{
  _toolbutton2->setTextLabel(tr(""));
  emit setInputMode(InputMode(InputMode::KanaInput));
}


void
MainForm::slotTriggerNotify(bool b)
{
  static bool     tiggerflag = FALSE;
  static QString  latestlabel = tr("");
  
  if (tiggerflag != b) {
    tiggerflag = b;
    
    if ( tiggerflag ) {
      _toolbutton1->setTextLabel(latestlabel);
      _popupmenu1->setItemEnabled(InputMode::Hiragana, TRUE);
      _popupmenu1->setItemEnabled(InputMode::Katakana, TRUE);
      _popupmenu1->setItemEnabled(InputMode::ZenkakuEisu, TRUE);
      _popupmenu2->setItemEnabled(InputMode::RomaInput, TRUE);
      _popupmenu2->setItemEnabled(InputMode::KanaInput, TRUE);

    } else {
      latestlabel = _toolbutton1->textLabel();
      _toolbutton1->setTextLabel(QString("A_"));
      _popupmenu1->setItemEnabled(InputMode::Hiragana, FALSE);
      _popupmenu1->setItemEnabled(InputMode::Katakana, FALSE);
      _popupmenu1->setItemEnabled(InputMode::ZenkakuEisu, FALSE);
      _popupmenu2->setItemEnabled(InputMode::RomaInput, FALSE);
      _popupmenu2->setItemEnabled(InputMode::KanaInput, FALSE);
    }
  }
}




