#include "kimeraapp.h"
#include "mainform.h"
#include <qtextcodec.h>
#include <qapplication.h>

void 
outputMessage(QtMsgType type, const char *msg)
{
#ifndef QT_NO_DEBUG
  switch ( type ) {
  case QtDebugMsg:

    fprintf(stderr, "%s\n", msg);

    break;
    
  case QtWarningMsg:

    fprintf(stderr, "Warning: %s\n", msg);
    break;
    
  case QtFatalMsg:
    fprintf(stderr, "Fatal: %s\n", msg);
    abort();          // dump core on purpose
  }
#endif
}


int 
main(int argc, char* argv[])
{
  qInstallMsgHandler(outputMessage);
  KimeraApp app(argc, argv);

  QTextCodec*  codec = QTextCodec::codecForName("eucJP");  
  Q_CHECK_PTR( codec );
  qDebug("codec: %s", codec->name());    
  app.setDefaultCodec(codec); 

  MainForm* mainwidget = new MainForm();
  app.setMainWidget(mainwidget);
  mainwidget->show();

  return app.exec();
}
