#ifndef INPUTMODE_H
#define INPUTMODE_H

class InputMode {
public:
  enum ModeIDs {
    Hiragana    = 0x0001,  // Ҥ餬
    Katakana    = 0x0002,  // 
    ZenkakuEisu = 0x0004,  // ѱѿ
    Hankaku     = 0x0008,  // Ⱦ
    ModeMask    = 0x000f,
    RomaInput   = 0x0010,  // ޻
    KanaInput   = 0x0020,  // 
    InputMask   = 0x00f0
  };
  
  InputMode(int mode = Hiragana | RomaInput) : _mode(mode) { };
  inline ModeIDs id() const { return (ModeIDs)_mode; }

  InputMode& merge(const InputMode& mode) {
    if (mode.id() & ModeMask) {
      _mode = (_mode & InputMask) | (mode.id() & ModeMask);

    } else if(mode.id() & InputMask) {
      _mode = (mode.id() & InputMask) | (_mode & ModeMask);
    }
    
    return *this;
  }

private:
  int  _mode;
};


#endif  // INPUTMODE_H
