#ifndef DICTHIRAGANA_H
#define DICTHIRAGANA_H

#include "inputmode.h"
#include <qdict.h>
#include <qstring.h>
#include <qevent.h>


class DictHiragana {
public:
  DictHiragana();
  ~DictHiragana();
  QString convertYomi(const QString&, const InputMode& mode = InputMode());
  QString forceConvtYomi(const QString&, const InputMode& mode = InputMode());
  QString convertYomi(const QKeyEvent&, const InputMode& mode = InputMode(InputMode::KanaInput | InputMode::Hiragana));   // Ѵ
  
protected:
  void initDict(const QString&, QDict<QString>& dict);
  QString convertToHira(const QString&);    // Ҥ餬Ѵ
  QString forceConvtToHira(const QString&);
  QString convertToKata(const QString&);    // Ѵ
  QString forceConvtToKata(const QString&);
  QString convertToZenkakuEisu(const QString&);   // ѱѿѴ

private:
  QDict<QString>     _dicthira;      // Ҥ餬ʼ
  QDict<QString>     _dictkata;      // ʼ
  QDict<QString>     _dictalphbt;    // ѱѻ
  QDict<QString>     _dictsymbol;    // ѿ漭
  QDict<QString>     _dictkanainp;   // ϼ
  QDict<QString>     _dictdakuten;   // Ѵ
};


#endif // DICTHIRAGANA_H
