#include "candidacylistbox.h"
#include <qrect.h>


CandidacyListBox::CandidacyListBox() : 
  QListBox((QWidget*)0, "candidacylistbox", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM), _curcandcyidx(0)
{
}


void
CandidacyListBox::showList(const QPoint& pos, const QStringList& strs, int curridx)
{
  Q_ASSERT( !count() );

  insertStringList(strs);  
  setGeometry(QRect(pos + QPoint(0, 3), QSize()));
  //_curcandcyidx = (count() > 1) ?  1 : 0;
  _curcandcyidx = (count() > curridx) ?  curridx : count() - 1;
  setCurrentItem(_curcandcyidx);
  ensureCurrentVisible();
  
  int w = totalWidth(); 
  int h = totalHeight(); 
  h += 6;
  w += (h > MAXHEIGHT) ? 22 : 6;
  
  qDebug("CandidacyListBox w:%d h:%d", w, h);
  resize(w, h);
  //setBottomItem(curitemidx);
  show();
}


void
CandidacyListBox::showPreviousCandidacy()
{
  if ( !count() ) {
    Q_ASSERT( count() );
    return;
  }
  
  _curcandcyidx--;
  _curcandcyidx = (_curcandcyidx < 0) ? count() - 1 : _curcandcyidx;
  //setTopItem(_curcandcyidx);
  setCurrentItem(_curcandcyidx);
  ensureCurrentVisible(); 
}


void
CandidacyListBox::showNextCandidacy()
{
  if ( !count() ) {
    Q_ASSERT( count() );
    return;
  }
  
  _curcandcyidx++;
  _curcandcyidx = (_curcandcyidx < count()) ? _curcandcyidx : 0;
  //setBottomItem(_curcandcyidx);
  setCurrentItem(_curcandcyidx);
  ensureCurrentVisible(); 
}


void
CandidacyListBox::hide()
{
  QWidget::hide();
  clear();
  _curcandcyidx = 0;
}



void
CandidacyListBox::setFont(const QFont& f)
{
  QListBox::setFont(f);
  
  //setMargin( 1 );
  setMargins(1, 2, 1, 2);
  //setAutoMask( FALSE );
  setFrameStyle( QFrame::Plain | QFrame::Box );
  setLineWidth( 1 );
  setColumnMode( 1 );   // Number of column is 1
  setMaximumHeight( MAXHEIGHT );
  setHScrollBarMode( AlwaysOff );
}










