#include "maintoolbar.h"
#include "kimeraglobal.h"
#include "kimeraapp.h"
#include "inputmethod.h"
#include "inputmode.h"
#include "propertydialog.h"
#include "keyassigner.h"
#include "config.h"
#include "kanjiengine.h"
#include "debug.h"
#include <QLayout>
#include <QToolTip>
#include <QString>
#include <QTimer>
#include <QMessageBox>
#include <QPixmap>
#include <QProcess>
#include <QDir>
#include <QMouseEvent>
#include <QEvent>
#include <QDesktopWidget>
#include <QActionGroup>
#include <QAction>
using namespace Kimera;

static const char* property_xpm[] = {
  "16 16 79 2",
  "   c None",
  ".a c #383858",
  ".e c #5a5a79",
  ".K c #676786",
  ".o c #6a6a88",
  ".8 c #6d6d8c",
  ".0 c #71718f",
  "#j c #737391",
  ".P c #757592",
  "#e c #767693",
  "#m c #777795",
  ".t c #797b97",
  "#i c #7b7b98",
  ".3 c #7c7c98",
  ".2 c #7e7e9a",
  "#d c #7f7e9a",
  "#h c #7f7e9b",
  ".1 c #80809b",
  ".f c #82829e",
  "#c c #83829e",
  ".# c #83839f",
  "## c #8886a2",
  ".Q c #8989a3",
  "#. c #8b8ba6",
  ".7 c #8f8fa9",
  ".6 c #9595ae",
  "#l c #9797af",
  ".Z c #9a9ab2",
  ".Y c #9f9fb6",
  "#g c #a1a1b8",
  ".X c #a5a5bb",
  ".O c #a5a6bc",
  "#b c #a8a8bd",
  ".N c #aaabbf",
  ".J c #abaabf",
  ".9 c #afafc3",
  ".E c #b0afc4",
  ".I c #b0b0c4",
  "#k c #b1b1c5",
  "#f c #b2b2c5",
  "#a c #b5b5c8",
  ".z c #b6b6c9",
  ".M c #b7b7c9",
  ".5 c #b8b8ca",
  ".4 c #b9b9cb",
  ".x c #bcbccc",
  ".W c #c1c0d1",
  ".r c #c1c1d1",
  ".q c #c7c5d5",
  ".w c #c7c7d5",
  ".p c #cbcbd8",
  ".D c #cbcbda",
  ".n c #cbccda",
  ".H c #ccccd8",
  ".v c #ccccda",
  ".m c #cfd0dc",
  ".k c #d0cfdc",
  ".u c #d0d0dc",
  ".j c #d5d5e0",
  ".C c #d8d8e2",
  ".G c #d8d9e2",
  ".l c #d9d8e2",
  ".i c #d9d9e2",
  ".h c #dbdbe6",
  ".d c #dddbe6",
  ".B c #dddde6",
  ".g c #dfdfe8",
  ".c c #e0dfe8",
  ".y c #e0e0e8",
  ".V c #e1e1e9",
  ".b c #e2e2e9",
  ".U c #e3e3eb",
  ".T c #e5e5ec",
  ".S c #e8e8ed",
  ".R c #eaeaf0",
  ".L c #ededf2",
  ".F c #f1f1f5",
  ".A c #f2f2f5",
  ".s c #f3f3f6",
  "        .#.#.#.#.#              ",
  "        .a.b.b.c.d.e.e          ",
  "        .f.a.g.h.i.j.k.e        ",
  "          .f.a.l.j.m.n.e        ",
  ".o.o        .f.#.k.p.q.r.e      ",
  ".o.s.#      .t.u.v.w.r.x.e      ",
  ".o.s.y.#  .t.u.p.w.r.x.z.e      ",
  ".o.A.B.C.t.u.D.w.r.x.z.E.e      ",
  ".o.F.G.j.k.H.w.r.x.z.I.J.e      ",
  ".o.K.L.u.v.w.r.x.M.I.N.O.P.e    ",
  "  .a.Q.R.S.T.U.V.u.W.X.Y.Z.0.e  ",
  "  .f.a.a.f.1.2.3.f.4.5.Z.6.7.8.e",
  "      .f.a.a.a.a.a.2.M.9.7#.##.o",
  "                .f.a.t#a#b###c#d",
  "                  .f.a#e#f#g#h#i",
  "                    .f.a#j#k#l#m"
};

static const char* dict_xpm[] = {
  "16 16 69 1",
  "< c None",
  "  c #643634",
  ". c #A48A6C",
  "X c #7C2624",
  "o c #AC6A74",
  "O c #B4A18C",
  "+ c #94765C",
  "@ c #CCB0B4",
  "# c #9C5E64",
  "$ c #98161B",
  "% c #C0AEA8",
  "& c #A05254",
  "* c #943A34",
  "= c #5C1514",
  "- c #891B1C",
  "> c #9C8684",
  "1 c #946E54",
  "2 c #A86054",
  "3 c #C4B6A4",
  "4 c #BDB6B4",
  "5 c #CC8684",
  "6 c #704244",
  "8 c #9C7E7C",
  "9 c #981A1C",
  "0 c #B4726C",
  "q c #8C3331",
  "w c #7C1214",
  "e c #740E0C",
  "r c #541A14",
  "t c #846264",
  "u c #AF9E84",
  "p c #670D0C",
  "a c #AC9A84",
  "s c #B4868C",
  "d c #6C3A38",
  "f c #882A2C",
  "g c #E0C2C4",
  "j c #9C7274",
  "k c #AC6C5C",
  "l c #C4BABC",
  "z c #542420",
  "x c #BCB2B4",
  "c c #D4A6A4",
  "v c #945644",
  "b c #7C5654",
  "n c #9C464C",
  "M c #6C4644",
  "N c #9C9294",
  "B c #A97D6C",
  "V c #AC987C",
  "C c #A48E74",
  "Z c #BC6E64",
  "A c #B49194",
  "S c #B4625C",
  "D c #D4C6C7",
  "F c #DCA2A4",
  "G c #946250",
  "H c #BCAAAC",
  "J c #8C5A5C",
  "K c #846654",
  "L c #B4A2A4",
  "P c #7C4E4C",
  "I c #8B1619",
  "U c #94483C",
  "Y c #C4928C",
  "T c #94423C",
  "R c #C48A8C",
  "E c #6C463C",
  "W c #9C8E8C",
  "<<<<<<<<<<@AA<<<",
  "<D#&nqX9I-wIX<<<",
  "<dpIII$II$wI-g<<",
  "g pI9$$$IIII-s<<",
  "LMpI$$99$I9I-&<<",
  "H6rw$$$$$$9I9f<<",
  "4P=w$9$99I99--@<",
  "xPze9$9999$9I-o<",
  "%P pI9$9$I99IIq<",
  "lJ p$9$$99IIII-D",
  "xj =I9$$99I$--XH",
  "x86zq*TTTUvG1+.<",
  "x>6ECVVVVaauaV3<",
  "4WbKauOOOOOaaV%<",
  "4WtGBBBkkS2S0Z5<",
  "4NARYcFg<<<<<<<<",
};


MainToolBar::MainToolBar()
  : QFrame(0, Qt::Tool | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint | Qt::X11BypassWindowManagerHint),
        _leftmover(new Mover(this)),
        _toolbtn1(new QToolButton(this)),
        _toolbtn2(new QToolButton(this)),
        _toolbtn3(new QToolButton(this)),
        _toolbtn4(new QToolButton(this)),
        _pupmenu1(new Popup(this)),
        _pupmenu2(new Popup(this)),
        _pupmenu3(new Popup(this)),
        _propdlg(new PropertyDialog(this)),
        _inputmodegrp(new QActionGroup(this)),
        _inputstylegrp(new QActionGroup(this)),
        _modemap(),
        _labelmap(),
        _handwriting(0)
{
  setAttribute( Qt::WA_DeleteOnClose );
  setAttribute( Qt::WA_AlwaysShowToolTips );
  setFrameShape( QFrame::StyledPanel );
  setFrameShadow( QFrame::Raised );

  QFont f("gothic", 9);
  const QSize btnsize(30, 26);
  QPoint pos(15, 3);

  _leftmover->move(1, 3);
  _leftmover->setMaximumHeight( btnsize.height() );

  _toolbtn1->move( pos );
  _toolbtn1->resize( btnsize );
  pos += QPoint(_toolbtn1->width(), 0);
  _toolbtn1->setAutoRaise(true);

  _toolbtn2->move( pos );
  _toolbtn2->resize( btnsize + QSize(6, 0) );
  pos += QPoint(_toolbtn2->width(), 0);
  _toolbtn2->setAutoRaise(true);

  _toolbtn3->move( pos );
  _toolbtn3->resize( btnsize );
  pos += QPoint(_toolbtn3->width(), 0);
  _toolbtn3->setIcon( QIcon(QPixmap((const char**)dict_xpm)) );  
  _toolbtn3->setMaximumSize( btnsize );
  _toolbtn3->setAutoRaise(true);

  _toolbtn4->move( pos );
  _toolbtn4->resize( btnsize );
  pos += QPoint(_toolbtn4->width(), 0);
  _toolbtn4->setIcon( QIcon(QPixmap((const char**)property_xpm)) );
  _toolbtn4->setText( tr("ץѥƥ") );
  _toolbtn4->setMaximumSize( btnsize );
  _toolbtn4->setAutoRaise(true);

  _handwriting = KanjiEngine::kanjiEngine("Tomoe");
  Q_CHECK_PTR( _handwriting );

  _inputmodegrp->addAction( _pupmenu1->addAction(tr("Ҥ餬")) )->setCheckable(true);
  _inputmodegrp->addAction( _pupmenu1->addAction(tr("")) )->setCheckable(true);
  _inputmodegrp->addAction( _pupmenu1->addAction(tr("Ⱦѥ")) )->setCheckable(true);
  _inputmodegrp->addAction( _pupmenu1->addAction(tr("ѱѿ")) )->setCheckable(true);
  QAction* act = _inputmodegrp->addAction( _pupmenu1->addAction(tr("ľ")) );
  act->setCheckable(true);
  act->setChecked(true);
  _inputmodegrp->setExclusive(true);

  _inputstylegrp->addAction( _pupmenu2->addAction(tr("޻")) )->setCheckable(true);
  _inputstylegrp->addAction( _pupmenu2->addAction(tr("")) )->setCheckable(true);
  _inputstylegrp->setExclusive( true );

  _pupmenu3->addAction(tr("ġ"), this, SLOT(execDictTool()));
  _pupmenu3->addAction(tr("ǧ"), this, SLOT(execHandWritingTool()));

  _toolbtn1->setMenu(_pupmenu1);
  _toolbtn1->setPopupMode(QToolButton::DelayedPopup);
  _toolbtn1->setFocusPolicy(Qt::NoFocus);
  _toolbtn2->setMenu(_pupmenu2);
  _toolbtn2->setPopupMode(QToolButton::DelayedPopup);
  _toolbtn2->setFocusPolicy(Qt::NoFocus);
  _toolbtn3->setMenu(_pupmenu3);
  _toolbtn3->setPopupMode(QToolButton::DelayedPopup);
  _toolbtn3->setFocusPolicy(Qt::NoFocus);
 
  _modemap.insert(tr("Ҥ餬"),     int(Mode_Hiragana));
  _modemap.insert(tr(""),     int(Mode_Katakana));
  _modemap.insert(tr("Ⱦѥ"),     int(Mode_HankakuKana));
  _modemap.insert(tr("ѱѿ"),     int(Mode_ZenkakuEisu));
  _modemap.insert(tr("޻"), int(Mode_RomaInput));
  _modemap.insert(tr(""),     int(Mode_KanaInput));
  _modemap.insert(tr("ľ"),     int(Mode_DirectInput));

  _labelmap.insert(Mode_Hiragana,    QString(tr("")));
  _labelmap.insert(Mode_Katakana,    QString(tr("")));
  _labelmap.insert(Mode_HankakuKana, QString(tr("_")));
  _labelmap.insert(Mode_ZenkakuEisu, QString(tr("")));
  _labelmap.insert(Mode_RomaInput,   QString(tr("-")));
  _labelmap.insert(Mode_KanaInput,   QString(tr(" ")));
  _labelmap.insert(Mode_DirectInput, QString(tr("_A")));

  // Sets tooltip
  _toolbtn1->setToolTip(tr("ϥ⡼"));
  _toolbtn2->setToolTip(tr(""));
  _toolbtn3->setToolTip(tr("ġ"));
  _toolbtn4->setToolTip(tr("ץѥƥ"));

  // Sets size
  resize(QSize(142, 34));
  
  // signals and slots connections
  InputMethod* im = KimeraApp::inputmethod();
  connect(im, SIGNAL(triggerNotify(bool)), this, SLOT(slotTriggerNotify(bool)));
  connect(this, SIGNAL(triggerNotify(bool)), im, SLOT(setXIMInputtingEnabled(bool)));
  connect(this, SIGNAL(selected(const InputMode&)), im->kanjiConvert(), SLOT(setInputMode(const InputMode&)));
  connect(im->kanjiConvert(), SIGNAL(inputModeChanged(const InputMode&)), this, SLOT(update(const InputMode&)));
  connect(_pupmenu1, SIGNAL(triggered(QAction*)), this, SLOT(setInputModeButtonText(QAction*)));
  connect(_pupmenu2, SIGNAL(triggered(QAction*)), this, SLOT(setInputStyleButtonText(QAction*)));
  connect(_toolbtn4, SIGNAL(clicked()),    this, SLOT(showPropertyDialog()));
  connect(_leftmover,  SIGNAL(mouseMoved(const QPoint&)), this, SLOT(move(const QPoint&)));
  connect(_leftmover,  SIGNAL(mouseMoveStopped(const QPoint&)), this, SLOT(savePos()));
  connect(im->kanjiConvert(), SIGNAL(dictToolActivated()), this, SLOT(execDictTool()));
  connect(im->kanjiConvert(), SIGNAL(propertyDialogActivated()), this, SLOT(showPropertyDialog()));
  connect(_propdlg, SIGNAL(settingChanged()), this, SLOT(initIM()));
  connect(_handwriting, SIGNAL(decided(const QString&)), this, SLOT(slotDecided(const QString&)));
  connect(this, SIGNAL(decided(const QString&)), KimeraApp::inputmethod()->kanjiConvert(), SIGNAL(decideSegments(const QString&)));

  for (int i = 1; i <= 20; ++i)
    QTimer::singleShot(5000 * i, this, SLOT(raise()));  // To stay on top at starting up on Gnome

  // Save Default setting
  PropertyDialog::saveDefaultSetting();
  KeyAssigner::saveDefaultSetting();

  // Sets default value
  int p = _modemap.value( Config::readEntry("_cmbinputmode", "") );
  if (p > 0) {
    setButton1Text( p );   // Default value
  }
  setButton1Text( Mode_DirectInput );

  p = _modemap.value( Config::readEntry("_cmbinputstyle", "") );
  if (p > 0) {
    setButton2Text( p );
  }

  if ( isHideState() )
    QTimer::singleShot(0, this, SLOT(hide()));
}


MainToolBar::~MainToolBar()
{
  // Do nothing
}


void
MainToolBar::initIM()
{
  DEBUG_TRACEFUNC();
  KimeraApp::inputmethod()->kanjiConvert()->init();
  if ( isHideState() )
    hide();
}


void
MainToolBar::setInputModeButtonText(QAction* action)
{
  DEBUG_TRACEFUNC("action: %s", qPrintable(action->text()));
  action->setChecked(true);
  int id = _modemap.value( action->text() );
  setButton1Text( id );
}


void
MainToolBar::setInputStyleButtonText(QAction* action)
{
  DEBUG_TRACEFUNC("action: %s", qPrintable(action->text()));
  action->setChecked(true);
  int id = _modemap.value( action->text() );
  setButton2Text( id );
}


void
MainToolBar::setButton1Text(int id)
{
  DEBUG_TRACEFUNC("id: 0x%04x", id);

  id &= Mode_ModeMask | Mode_DirectInput;
  QString str = _modemap.key(id);
  if ( str.isEmpty() )
    return;

  // Sets check-flag to popup menu
  foreach (QAction* act, _pupmenu1->actions()) {
    act->setChecked( (act->text() == str) );
  }

  QString p = _labelmap.value(id);
  Q_ASSERT( !p.isEmpty() );
  _toolbtn1->setText(p);

  if ( !(id & Mode_DirectInput) )
    emit selected(InputMode(id));

  slotTriggerNotify( !(id & Mode_DirectInput) );
}


void
MainToolBar::setButton2Text(int id)
{
  DEBUG_TRACEFUNC("id: 0x%04x", id);

  id &= Mode_InputMask;
  QString str = _modemap.key(id);
  if ( str.isEmpty() )
    return;

  // Sets check-flag to popup menu
  foreach (QAction* act, _pupmenu2->actions()) {
    act->setChecked( (act->text() == str) );
  }

  QString p = _labelmap.value(id);
  Q_ASSERT( !p.isEmpty() );
  _toolbtn2->setText(p);

  emit selected(InputMode(id));
}


void
MainToolBar::slotTriggerNotify(bool b)
{
  DEBUG_TRACEFUNC("b: %d", b); 
  static int prev_id = 0;

  // Check on/off changed
  int id =  b ? KimeraApp::inputmethod()->kanjiConvert()->inputMode().id() : Mode_DirectInput;
  if ((id & Mode_DirectInput) == (prev_id & Mode_DirectInput)) {
    return;
  } 

  prev_id = id;
  setButton1Text( id );
  emit triggerNotify( b );
  
  if ( isHideState() ) {
    hide();
  } else {
    clearFocus();
    show();
    raise();
  }
}


void
MainToolBar::execDictTool()
{
  DEBUG_TRACEFUNC();

  static QProcess* proc = 0;
  if (!proc) {
    proc = new QProcess(this);
    proc->setWorkingDirectory(QDir::homePath());

    QStringList env = QProcess::systemEnvironment();
    env << "XMODIFIERS=@im=kimera";
    proc->setEnvironment( env );
  }
  if (proc->state() != QProcess::Running) {
    QStringList arguments = Config::readEntry("_cmbcmd", "").split(' ', QString::SkipEmptyParts);
    if (!arguments.isEmpty()) {
      QString cmd = arguments.takeFirst();
      proc->start(cmd, arguments);
    } else {
      QMessageBox::warning(this, "Empty command",
                           tr("ġ뤬ꤵƤޤ\n"
                              "ץѥƥ饳ޥɤꤷƤ"),
                           QMessageBox::Ok | QMessageBox::Default, 0);
    }
  }
}


void
MainToolBar::execHandWritingTool()
{
  DEBUG_TRACEFUNC();

  slotTriggerNotify( true );
  if ( !_handwriting->init() ) {
    QMessageBox::warning(this, "Execution failed",
                         tr("ǧġkimera-tomoe-gtkˤưǤޤǤ"),
                         QMessageBox::Ok | QMessageBox::Default, 0);
  }
}


void
MainToolBar::slotDecided(const QString& string)
{
  DEBUG_TRACEFUNC("string: %s", qPrintable(string));

  if ( !KimeraApp::isXIMInputtingEnabled() )
    slotTriggerNotify( true );

  emit decided(string);
}


void
MainToolBar::showPropertyDialog()
{
  DEBUG_TRACEFUNC();
  _propdlg->show();
  _propdlg->raise();
}


bool
MainToolBar::isHideState()
{
  DEBUG_TRACEFUNC();
  return !KimeraApp::isXIMInputtingEnabled() && Config::readBoolEntry("_chkdispbar");
}


void
MainToolBar::savePos()
{
  DEBUG_TRACEFUNC();
  Config::writeEntry("point_x", x());
  Config::writeEntry("point_y", y());
  qDebug("saved (%d, %d)", x(), y());
}


QPoint
MainToolBar::loadPos() const
{
  DEBUG_TRACEFUNC();

  int x = Config::readNumEntry("point_x", -1);
  int y = Config::readNumEntry("point_y", -1);
  if (x < 0 || y < 0) {
    x = QApplication::desktop()->screen(0)->width() - width() - 50;
    y = QApplication::desktop()->screen(0)->height() - 120;
  }
  
  x = qMin(qMax(x, 0), QApplication::desktop()->width() - width());
  y = qMin(qMax(y, 0), QApplication::desktop()->height() - height()); 
  return QPoint(x, y);
}


void
MainToolBar::update(const InputMode& mode)
{
  DEBUG_TRACEFUNC("mode: 0x%04x", mode.id());
  setButton1Text(mode.id());
  setButton2Text(mode.id());
  slotTriggerNotify( !(mode.id() & Mode_DirectInput) ); 
}


void
MainToolBar::move(const QPoint& pos)
{
  DEBUG_TRACEFUNC();
  QWidget::move(pos);
}


/**
 * Mover class
 */
Mover::Mover(QWidget* parent) : QToolButton(parent)
{
  setMaximumWidth(14);
  setAutoRaise(true);
}


void
Mover::mousePressEvent(QMouseEvent* e)
{
  _p = e->globalPos();
  if ( topLevelWidget() ) {
    _p -= topLevelWidget()->pos();
  }
  
  QToolButton::mousePressEvent(e);
}


void
Mover::mouseReleaseEvent(QMouseEvent* e)
{
  emit mouseMoveStopped(e->globalPos() - _p);
  QToolButton::mouseReleaseEvent(e);
}


void
Mover::mouseMoveEvent(QMouseEvent* e) 
{
  emit mouseMoved(e->globalPos() - _p);
  QToolButton::mouseMoveEvent(e);
}


void
Mover::enterEvent(QEvent* e)
{
  QApplication::setOverrideCursor( QCursor(Qt::SizeAllCursor) );
  QToolButton::enterEvent(e);
}


void
Mover::leaveEvent(QEvent* e)
{
  QApplication::restoreOverrideCursor();
  QToolButton::leaveEvent(e);
}
