#include "keyassigner.h"
#include "kimeraglobal.h"
#include "config.h"
#include "debug.h"
#include <QVector>
#include <QString>
#include <QMessageBox>
#include <QTimer>
#include <QHeaderView>

const QString PREFIX = "ktbl";
const int  MAX_AVAILABLE_KEYS = 60;

static QVector<QString>  FuncName(FID_NumFunctions);


class VariableInitializer {
  Q_DECLARE_TR_FUNCTIONS(VariableInitializer)

public:
  VariableInitializer();
};
static VariableInitializer initializer;


VariableInitializer::VariableInitializer()
{
  //
  // variable initialize
  //
}


static int KeyAssign[NUM_SETTING_TYPE][MAX_AVAILABLE_KEYS][NUM_OF_CONVSTATUS + 1] = {
  { { Qt::Key_Space,     FID_InsertSpace, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },    // MSIME
    { Qt::CTRL+Qt::Key_Space,  FID_None, FID_ConvertToOneSegment, FID_None, FID_None, FID_None },
    { Qt::SHIFT+Qt::Key_Space, FID_InsertOtherWidthSpace, FID_ConvertAllSegments, FID_PreviousCandidate, FID_PreviousCandidate, FID_ConvertCrntSegment }, 
    { Qt::CTRL+Qt::SHIFT+Qt::Key_Space,  FID_InsertMultibyteSpace, FID_None, FID_None, FID_None, FID_None },
    { Qt::Key_Return,    FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Enter,     FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::CTRL+Qt::Key_Return, FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::CTRL+Qt::Key_Enter,  FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::SHIFT+Qt::Key_Return, FID_None, FID_DecidePredictedCandidate, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::SHIFT+Qt::Key_Enter,  FID_None, FID_DecidePredictedCandidate, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Backspace, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::CTRL+Qt::Key_Backspace, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::SHIFT+Qt::Key_Backspace, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::Key_Delete,    FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::Key_Escape,    FID_None, FID_DeleteAll, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::SHIFT+Qt::Key_Escape, FID_None, FID_DeleteAll, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::CTRL+Qt::Key_A, FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_D, FID_None, FID_CaretForward, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::CTRL+Qt::Key_E, FID_None, FID_CaretToFirst, FID_PreviousCandidate, FID_PreviousCandidate, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_F, FID_None, FID_CaretToLast, FID_ToLastSegment, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_G, FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_H, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::CTRL+Qt::Key_I, FID_None, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::CTRL+Qt::Key_K, FID_None, FID_CaretBackward, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_L, FID_None, FID_CaretForward, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_M, FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::CTRL+Qt::Key_N, FID_None, FID_CaretToLast, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_DecideCrntSegment },
    { Qt::CTRL+Qt::Key_O, FID_None, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::CTRL+Qt::Key_P, FID_None, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::CTRL+Qt::Key_S, FID_None, FID_CaretBackward, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::CTRL+Qt::Key_T, FID_None, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu },
    { Qt::CTRL+Qt::Key_U, FID_None, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::CTRL+Qt::Key_X, FID_None, FID_CaretToLast, FID_NextCandidate, FID_NextCandidate, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_Z, FID_None, FID_DeleteAll, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::Key_Left,      FID_None, FID_CaretBackward, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::Key_Right,     FID_None, FID_CaretForward, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::Key_Up,        FID_None, FID_CaretToFirst, FID_PreviousCandidate, FID_PreviousCandidate, FID_ShortenSegment },
    { Qt::Key_Down,      FID_None, FID_CaretToLast, FID_NextCandidate, FID_NextCandidate, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_Left,   FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_Right,  FID_None, FID_CaretToLast, FID_ToLastSegment, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_Up,     FID_None, FID_CaretToFirst, FID_PreviousCandidate, FID_PreviousCandidate, FID_None },
    { Qt::CTRL+Qt::Key_Down,   FID_None, FID_CaretToLast, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_DecideCrntSegment },
    { Qt::SHIFT+Qt::Key_Left,  FID_None, FID_CaretBackward, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::SHIFT+Qt::Key_Right, FID_None, FID_CaretForward, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::SHIFT+Qt::Key_Up,    FID_None, FID_None, FID_None, FID_PreviousCandidateGroup, FID_None },
    { Qt::SHIFT+Qt::Key_Down,  FID_None, FID_None, FID_None, FID_NextCandidateGroup, FID_None },
    { Qt::Key_PageUp,    FID_None, FID_None, FID_None, FID_PreviousCandidateGroup, FID_None },
    { Qt::Key_PageDown,  FID_None, FID_None, FID_None, FID_NextCandidateGroup, FID_None },    
    { Qt::Key_F6,        FID_None, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::Key_F7,        FID_None, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::Key_F8,        FID_None, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::Key_F9,        FID_None, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::Key_F10,       FID_None, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu },
    { Qt::Key_Henkan,    FID_ReconvertClipboardString, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment }, },

  { { Qt::Key_Space,     FID_InsertSpace, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },   // ATOK
    { Qt::CTRL+Qt::Key_Space,  FID_None, FID_ConvertToOneSegment, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::SHIFT+Qt::Key_Space, FID_InsertOtherWidthSpace, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::Key_Return,    FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Enter,     FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::SHIFT+Qt::Key_Return,    FID_None, FID_DecidePredictedCandidate, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::SHIFT+Qt::Key_Enter,     FID_None, FID_DecidePredictedCandidate, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Backspace, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::Key_Delete,    FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_Delete,     FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::SHIFT+Qt::Key_Delete,    FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::Key_Escape,    FID_None, FID_DeleteAll, FID_DeleteAll, FID_DeleteAll, FID_DeleteAll },
    { Qt::SHIFT+Qt::Key_Escape, FID_None, FID_DeleteAll, FID_DeleteAll, FID_DeleteAll, FID_DeleteAll },
    { Qt::Key_Insert,    FID_None, FID_None, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::CTRL+Qt::Key_Insert, FID_None, FID_None, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::SHIFT+Qt::Key_Insert, FID_None, FID_None, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::CTRL+Qt::Key_A, FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_ToFirstSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_D, FID_None, FID_CaretForward, FID_ForwardSegment, FID_ForwardSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_E, FID_None, FID_None, FID_PreviousCandidate, FID_PreviousCandidate, FID_None },
    { Qt::CTRL+Qt::Key_F, FID_None, FID_CaretToLast, FID_ToLastSegment, FID_ToLastSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_G, FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_H, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::CTRL+Qt::Key_I, FID_None, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::CTRL+Qt::Key_K, FID_None, FID_CaretBackward, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_L, FID_None, FID_CaretForward, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_M, FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::CTRL+Qt::Key_N, FID_None, FID_DecideAllSegments, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_DecideCrntSegment },
    { Qt::CTRL+Qt::Key_O, FID_None, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::CTRL+Qt::Key_P, FID_None, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::CTRL+Qt::Key_S, FID_None, FID_CaretBackward, FID_BackwardSegment, FID_BackwardSegment, FID_ShortenSegment },   
    { Qt::CTRL+Qt::Key_U, FID_None, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::CTRL+Qt::Key_At, FID_None, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu },
    { Qt::Key_Home,      FID_None, FID_CaretToFirst, FID_None, FID_None, FID_None },
    { Qt::Key_End,       FID_None, FID_CaretToLast, FID_None, FID_None, FID_None },
    { Qt::Key_Left,      FID_None, FID_CaretBackward, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::Key_Right,     FID_None, FID_CaretForward, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::Key_Up,        FID_None, FID_None, FID_PreviousCandidate, FID_PreviousCandidate, FID_None },
    { Qt::Key_Down,      FID_None, FID_DecideAllSegments, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_DecideCrntSegment },
    { Qt::CTRL+Qt::Key_Left,   FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_ToFirstSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_Right,  FID_None, FID_CaretToLast, FID_ToLastSegment, FID_ToLastSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_Up,     FID_None, FID_None, FID_PreviousCandidate, FID_PreviousCandidate, FID_None },
    { Qt::SHIFT+Qt::Key_Left,  FID_None, FID_CaretBackward, FID_BackwardSegment, FID_BackwardSegment, FID_ShortenSegment },    
    { Qt::SHIFT+Qt::Key_Right, FID_None, FID_CaretForward, FID_ForwardSegment, FID_ForwardSegment, FID_LengthenSegment },
    { Qt::SHIFT+Qt::Key_Up,    FID_None, FID_None, FID_PreviousCandidate, FID_PreviousCandidate, FID_None },
    { Qt::SHIFT+Qt::Key_Down,  FID_None, FID_None, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_DecideCrntSegment },
    { Qt::Key_PageUp,    FID_None, FID_None, FID_PreviousCandidateGroup, FID_PreviousCandidateGroup, FID_None },
    { Qt::Key_PageDown,  FID_None, FID_None, FID_NextCandidateGroup, FID_NextCandidateGroup, FID_None }, 
    { Qt::Key_F6,        FID_None, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::Key_F7,        FID_None, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::Key_F8,        FID_None, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::Key_F9,        FID_None, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::Key_F10,       FID_None, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu },
    { Qt::Key_Henkan,    FID_ReconvertClipboardString, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },  
    { Qt::CTRL+Qt::Key_F7,  FID_ExecDictTool, FID_None, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_F12, FID_ShowPropertyDialog, FID_None, FID_None, FID_None, FID_None }, },
  
  { { Qt::Key_Space,      FID_InsertSpace, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },  // KINPUT2
    { Qt::CTRL+Qt::Key_Space, FID_None, FID_ConvertToOneSegment, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::SHIFT+Qt::Key_Space, FID_InsertOtherWidthSpace, FID_ConvertAllSegments, FID_PreviousCandidate, FID_PreviousCandidate, FID_ConvertCrntSegment },
    { Qt::Key_Return,     FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Enter,      FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::SHIFT+Qt::Key_Return, FID_None, FID_DecidePredictedCandidate, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::SHIFT+Qt::Key_Enter,  FID_None, FID_DecidePredictedCandidate, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Backspace,  FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::Key_Delete,     FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_A, FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_ToFirstSegment, FID_ToFirstSegment },
    { Qt::CTRL+Qt::Key_B, FID_None, FID_CaretBackward, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::CTRL+Qt::Key_D, FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_E, FID_None, FID_CaretToLast, FID_ToLastSegment, FID_ToLastSegment, FID_ToLastSegment },
    { Qt::CTRL+Qt::Key_F, FID_None, FID_CaretForward, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::CTRL+Qt::Key_G, FID_None, FID_DeleteAll, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::CTRL+Qt::Key_H, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::CTRL+Qt::Key_I, FID_None, FID_None, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_M, FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::CTRL+Qt::Key_N, FID_None, FID_None, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::SHIFT+Qt::Key_N, FID_None, FID_None, FID_NextCandidateGroup, FID_NextCandidateGroup, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::Key_O, FID_None, FID_None, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_P, FID_None, FID_None, FID_PreviousCandidate, FID_PreviousCandidate, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::SHIFT+Qt::Key_P, FID_None, FID_None, FID_PreviousCandidateGroup, FID_PreviousCandidateGroup, FID_ConvertCrntSegment },
    { Qt::Key_Left,      FID_None, FID_CaretBackward, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::Key_Right,     FID_None, FID_CaretForward, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::Key_Up,        FID_None, FID_None, FID_PreviousCandidate, FID_PreviousCandidate, FID_ConvertCrntSegment },
    { Qt::Key_Down,      FID_None, FID_None, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::Key_Left,  FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_ToFirstSegment, FID_ToFirstSegment },
    { Qt::CTRL+Qt::Key_Right, FID_None, FID_CaretToLast, FID_ToLastSegment, FID_ToLastSegment, FID_ToLastSegment },
    { Qt::CTRL+Qt::Key_Up,    FID_None, FID_None, FID_PreviousCandidateGroup, FID_PreviousCandidateGroup, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::Key_Down,  FID_None, FID_None, FID_NextCandidateGroup, FID_NextCandidateGroup, FID_ConvertCrntSegment },
    { Qt::SHIFT+Qt::Key_Left,  FID_None, FID_None, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::SHIFT+Qt::Key_Right, FID_None, FID_None, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::SHIFT+Qt::Key_Up,    FID_None, FID_None, FID_PreviousCandidate, FID_PreviousCandidate, FID_ConvertCrntSegment },
    { Qt::SHIFT+Qt::Key_Down,  FID_None, FID_None, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::Key_Home,      FID_None, FID_None, FID_FirstCandidate, FID_FirstCandidate, FID_ConvertCrntSegment },
    { Qt::Key_End,       FID_None, FID_None, FID_LastCandidate, FID_LastCandidate, FID_ConvertCrntSegment },
    { Qt::Key_PageUp,    FID_None, FID_None, FID_PreviousCandidateGroup, FID_PreviousCandidateGroup, FID_ConvertCrntSegment },
    { Qt::Key_PageDown,  FID_None, FID_None, FID_NextCandidateGroup, FID_NextCandidateGroup, FID_ConvertCrntSegment },
    { Qt::Key_F5,        FID_SwitchInputMethod, FID_None, FID_None, FID_None, FID_None },
    { Qt::Key_F6,        FID_SetToHiraganaMode, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::Key_F7,        FID_SetToKatakanaMode, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::Key_F8,        FID_SetToHankakuKanaMode, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::Key_F9,        FID_SetToZenkakuEisuMode, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::Key_F10,       FID_None, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu },
    { Qt::Key_F11,       FID_ExecDictTool, FID_None, FID_None, FID_None, FID_None },
    { Qt::Key_F12,       FID_ShowPropertyDialog, FID_None, FID_None, FID_None, FID_None },
    { Qt::Key_Henkan,    FID_ReconvertClipboardString, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },  },
  
  { { Qt::Key_Space,     FID_InsertSpace, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },    // VJE
    { Qt::CTRL+Qt::Key_Space, FID_None, FID_ConvertToOneSegment, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::SHIFT+Qt::Key_Space, FID_InsertOtherWidthSpace, FID_ConvertAllSegments, FID_LengthenSegment, FID_PreviousCandidate, FID_LengthenSegment },
    { Qt::CTRL+Qt::SHIFT+Qt::Key_Space, FID_InsertMultibyteSpace, FID_None, FID_BackwardSegment, FID_BackwardSegment, FID_None },
    { Qt::Key_Return,    FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Enter,     FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::CTRL+Qt::Key_Return,    FID_None, FID_DecideAllSegments, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_Enter,     FID_None, FID_DecideAllSegments, FID_None, FID_None, FID_None },
    { Qt::SHIFT+Qt::Key_Return,    FID_None, FID_DecidePredictedCandidate, FID_DecideAllSegments, FID_DecideAllSegments, FID_ConvertCrntSegment },
    { Qt::SHIFT+Qt::Key_Enter,     FID_None, FID_DecidePredictedCandidate, FID_DecideAllSegments, FID_DecideAllSegments, FID_ConvertCrntSegment },
    { Qt::Key_Backspace, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::Key_Delete,    FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::Key_Escape,    FID_None, FID_DeleteAll, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::SHIFT+Qt::Key_Escape, FID_None, FID_DeleteAll, FID_DeleteAll, FID_CancelConversion, FID_DeleteAll },
    { Qt::CTRL+Qt::Key_A, FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_C, FID_None, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::Key_D, FID_None, FID_CaretForward, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::CTRL+Qt::Key_E, FID_None, FID_CaretToFirst, FID_PreviousCandidate, FID_PreviousCandidateGroup, FID_None },
    { Qt::CTRL+Qt::Key_F, FID_None, FID_CaretToLast, FID_ToLastSegment, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_G, FID_None, FID_DeleteForwardChar, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_H, FID_None, FID_DeleteBackwardChar, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::CTRL+Qt::Key_I, FID_None, FID_None, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::CTRL+Qt::Key_J, FID_None, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::CTRL+Qt::Key_K, FID_None, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::CTRL+Qt::Key_L, FID_None, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::CTRL+Qt::Key_M, FID_None, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::CTRL+Qt::Key_O, FID_None, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::CTRL+Qt::Key_Q, FID_None, FID_CaretBackward, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_R, FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_PreviousCandidate, FID_BackwardSegment },
    { Qt::CTRL+Qt::Key_S, FID_None, FID_CaretBackward, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::CTRL+Qt::Key_W, FID_None, FID_CaretForward, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_X, FID_None, FID_CaretToLast, FID_NextCandidate, FID_NextCandidateGroup, FID_None },
    { Qt::CTRL+Qt::Key_Z, FID_None, FID_ConvertAllSegments, FID_PreviousCandidate, FID_PreviousCandidate, FID_ConvertCrntSegment },
    { Qt::Key_Home,      FID_None, FID_CaretToFirst, FID_ToFirstSegment, FID_None, FID_None },
    { Qt::Key_End,       FID_None, FID_CaretToLast, FID_ToLastSegment, FID_None, FID_None },
    { Qt::Key_Left,      FID_None, FID_CaretBackward, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::Key_Right,     FID_None, FID_CaretForward, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::Key_Up,        FID_None, FID_ConvertAllSegments, FID_PreviousCandidate, FID_PreviousCandidate, FID_ConvertCrntSegment },
    { Qt::Key_Down,      FID_None, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::Key_Up,     FID_None, FID_ConvertAllSegments, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_Down,   FID_None, FID_ConvertAllSegments, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_LengthenSegment },
    { Qt::SHIFT+Qt::Key_Left,  FID_None, FID_CaretBackward, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::SHIFT+Qt::Key_Right, FID_None, FID_CaretForward, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },    
    { Qt::SHIFT+Qt::Key_Up,    FID_None, FID_ConvertAllSegments, FID_PreviousCandidate, FID_PreviousCandidateGroup, FID_ConvertCrntSegment },
    { Qt::SHIFT+Qt::Key_Down,  FID_None, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidateGroup, FID_ConvertCrntSegment },
    { Qt::Key_PageUp,    FID_None, FID_CaretToFirst, FID_PreviousCandidate, FID_PreviousCandidateGroup, FID_None },
    { Qt::Key_PageDown,  FID_None, FID_CaretToLast, FID_NextCandidate, FID_NextCandidateGroup, FID_None }, 
    { Qt::Key_F6,        FID_None, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::Key_F7,        FID_None, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::Key_F8,        FID_None, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::Key_F9,        FID_None, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::Key_F10,       FID_None, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu },
    { Qt::Key_Henkan,    FID_ReconvertClipboardString, FID_ConvertAllSegments, FID_NextCandidate, FID_NextCandidate, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::Key_F2,  FID_ExecDictTool, FID_None, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_F3,  FID_SwitchInputMethod, FID_None, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_F6,  FID_SetToHiraganaMode, FID_None, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_F7,  FID_SetToKatakanaMode, FID_None, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_F8,  FID_SetToZenkakuEisuMode, FID_None, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_F9,  FID_SetToHankakuKanaMode, FID_None, FID_None, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_F10, FID_ShowPropertyDialog, FID_None, FID_None, FID_None, FID_None }, },

  { { 0 } },     // Current setting  (dummy)
};


KeyAssigner::KeyAssigner(QWidget* parent) : QDialog(parent)
{
  _ui.setupUi(this);
  _ui._keyassigntbl->setColumnCount( NUM_OF_CONVSTATUS + 1 );
  _ui._keyassigntbl->verticalHeader()->setResizeMode(QHeaderView::Stretch);
  _ui._keyassigntbl->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
  QStringList headerlabel;
  headerlabel << tr("") << tr("̤") << tr("") << tr("ѴѤ")
              << tr("ɽ") << tr("ʸĹѹ");
  _ui._keyassigntbl->setHorizontalHeaderLabels(headerlabel);

  _ui._cmbloadsetting->insertItem(ST_MSIME, tr("MS-IME"));
  _ui._cmbloadsetting->insertItem(ST_ATOK, tr("ATOK"));
  _ui._cmbloadsetting->insertItem(ST_KINPUT2, tr("Kinput2"));
  _ui._cmbloadsetting->insertItem(ST_VJE, tr("VJE"));
  _ui._cmbloadsetting->setToolTip( tr("ꥹȤ򤵤줿ɤ߹ߤޤ") );

  // Creates connections
  connect(_ui._okbtn, SIGNAL(clicked()), this, SLOT(accept()));
  connect(_ui._cancelbtn, SIGNAL(clicked()), this, SLOT(reject()));
  connect(_ui._cmbloadsetting, SIGNAL(activated(int)), this, SLOT(loadSetting(int)));

  // Call init function
  QTimer::singleShot(0, this, SLOT(init()));
}


void KeyAssigner::init()
{
  DEBUG_TRACEFUNC();
  FuncName[FID_None]                     = "-";
  FuncName[FID_InsertChar]               = tr("");
  FuncName[FID_NextCandidate]            = tr("");
  FuncName[FID_NextCandidateGroup]       = tr("䷲");
  FuncName[FID_PreviousCandidate]        = tr("");
  FuncName[FID_PreviousCandidateGroup]   = tr("䷲");
  FuncName[FID_FirstCandidate]           = tr("Ƭ");
  FuncName[FID_LastCandidate]            = tr("");
  FuncName[FID_ConvertAllSegments]       = tr("Ѵ");
  FuncName[FID_ConvertCrntSegment]       = tr("ʸѴ");
  FuncName[FID_ConvertToOneSegment]      = tr("ñʸѴ");
  FuncName[FID_DeleteForwardChar]        = tr("");
  FuncName[FID_DeleteBackwardChar]       = tr("");
  FuncName[FID_DeleteAll]                = tr("");
  FuncName[FID_DecideAllSegments]        = tr("");
  FuncName[FID_DecideCrntSegment]        = tr("ʸ");
  FuncName[FID_DecidePredictedCandidate] = tr("ͽ¬");
  FuncName[FID_CancelConversion]         = tr("ᤷ");
  FuncName[FID_LengthenSegment]          = tr("ʸĹܣ");
  FuncName[FID_ShortenSegment]           = tr("ʸĹ");
  FuncName[FID_InsertSpace]              = tr("ʸ");
  FuncName[FID_InsertAsciiSpace]         = tr("ȾѶ");
  FuncName[FID_InsertMultibyteSpace]     = tr("Ѷ");
  FuncName[FID_InsertOtherWidthSpace]    = tr("");
  FuncName[FID_ConvertToHira]            = tr("Ҥ餬");
  FuncName[FID_ConvertToKana]            = tr("");
  FuncName[FID_ConvertToHankakuKana]     = tr("Ⱦѥ");
  FuncName[FID_ConvertToHankakuEisu]     = tr("Ⱦѱѿ");
  FuncName[FID_ConvertToZenkakuEisu]     = tr("ѱѿ");
  FuncName[FID_ForwardSegment]           = tr("ʸᱦư");
  FuncName[FID_BackwardSegment]          = tr("ʸẸư");
  FuncName[FID_ToFirstSegment]           = tr("ʸƬ");
  FuncName[FID_ToLastSegment]            = tr("ʸ");
  FuncName[FID_CaretForward]             = tr("ư");
  FuncName[FID_CaretBackward]            = tr("ư");
  FuncName[FID_CaretToFirst]             = tr("Ƭư");
  FuncName[FID_CaretToLast]              = tr("ư");
  FuncName[FID_SwitchZenkakuEisuMode]    = tr("ѱѿ");
  FuncName[FID_SetToHiraganaMode]        = tr("Ҥ餬ʥ⡼");
  FuncName[FID_SetToKatakanaMode]        = tr("ʥ⡼");
  FuncName[FID_SetToHankakuKanaMode]     = tr("Ⱦѥʥ⡼");
  FuncName[FID_SetToZenkakuEisuMode]     = tr("ѱѿ⡼");
  FuncName[FID_SwitchInputMethod]        = tr("");
  FuncName[FID_ShowPropertyDialog]       = tr("ץѥƥ");
  FuncName[FID_ExecDictTool]             = tr("ġ");
  FuncName[FID_ReconvertClipboardString] = tr("Ѵ(¸Ū)");

  // Loads setting
  loadSetting(ST_CURRENT_SETTING);
}


void KeyAssigner::saveSetting()
{
  DEBUG_TRACEFUNC();
  for (int row = 0; row < MAX_AVAILABLE_KEYS; ++row) {
    if (row < _ui._keyassigntbl->rowCount()) {
      QKeySequence keyseq( _ui._keyassigntbl->item(row, 0)->data(Qt::UserRole).toInt() );
      int key = keyseq[0] & ~Qt::UNICODE_ACCEL;
      Config::writeEntry(PREFIX + QString::number(row) + "-" + QString::number(0), key);

      for (int col = 1; col <= NUM_OF_CONVSTATUS; ++col) {
	Config::writeEntry(PREFIX + QString::number(row) 
			   + "-" + QString::number(col), (int)functionID(_ui._keyassigntbl->item(row, col)->text()));
      }
    
    } else {
      // 0 clear
      for (int col = 0; col <= NUM_OF_CONVSTATUS; ++col)
	Config::writeEntry(PREFIX + QString::number(row) 
			   + "-" + QString::number(col), (int)0);
    }
  }

  Config::writeEntry("_cmbloadsetting", _ui._cmbloadsetting->currentIndex());
  KeyAssign[ST_CURRENT_SETTING][0][0] = 0;  // implies reloading function
}


void KeyAssigner::loadSetting( int index )
{
  DEBUG_TRACEFUNC("index: %d", index);
  _ui._keyassigntbl->clearContents();
  _ui._keyassigntbl->setRowCount(MAX_AVAILABLE_KEYS);

  int row = 0;
  switch ( index ) {
  case ST_CURRENT_SETTING:
    for (row = 0; row < MAX_AVAILABLE_KEYS; ++row) {
      int key = Config::readNumEntry(PREFIX + QString::number(row) + "-" + QString::number(0), 0);
      if ( !key )
	break;

      QKeySequence keyseq(key);
      setKeySequenceName(row, keyseq);

      for (int col = 1; col <= NUM_OF_CONVSTATUS; ++col) {
	int funcid = Config::readNumEntry(PREFIX + QString::number(row) + "-" + QString::number(col), FID_None);
	_ui._keyassigntbl->setItem(row, col, new QTableWidgetItem(functionName( (FuncID)funcid )));
      }
    }
    _ui._keyassigntbl->setRowCount(row);
    _ui._cmbloadsetting->setCurrentIndex( Config::readNumEntry("_cmbloadsetting", ST_MSIME) );
    break;
    
  case ST_MSIME:
  case ST_ATOK:
  case ST_KINPUT2:
  case ST_VJE:
    for (row = 0; row < MAX_AVAILABLE_KEYS; ++row) {
      if ( ! KeyAssign[index][row][0] )
	break;

      QKeySequence keyseq( KeyAssign[index][row][0] );
      setKeySequenceName(row, keyseq);

      for (int col = 1; col <= NUM_OF_CONVSTATUS; ++col) {
	_ui._keyassigntbl->setItem(row, col, new QTableWidgetItem(functionName( (FuncID)KeyAssign[index][row][col] )));
      }
    }
    _ui._keyassigntbl->setRowCount(row);
    break;
    
  default:
    break;
  }

  update();
}


QString KeyAssigner::functionName( FuncID id )
{
  DEBUG_TRACEFUNC("id: %d", (int)id);
  return FuncName.value(id);
}


FuncID KeyAssigner::functionID( const QString & func )
{
  DEBUG_TRACEFUNC("func: %s", qPrintable(func));
  int id;
  for (id = 0; id < FID_NumFunctions; ++id) {
    if (FuncName[id] == func) 
      break;
  }
  return (id < FID_NumFunctions) ? (FuncID)id : FID_None;
}


FuncID KeyAssigner::functionID( int key, ConvStatus stat )
{
  DEBUG_TRACEFUNC("key: 0x%x  stat: %d", key, stat);
  const int crntset = ST_CURRENT_SETTING;
  if ( !KeyAssign[crntset][0][0] ) {
    // Loads data
    for (int i = 0; i < MAX_AVAILABLE_KEYS; ++i) {
      KeyAssign[crntset][i][0] = Config::readNumEntry(PREFIX + QString::number(i) + "-" + QString::number(0), 0);
      for (int j = 1; j <= NUM_OF_CONVSTATUS; ++j) {
	KeyAssign[crntset][i][j] = Config::readNumEntry(PREFIX + QString::number(i) + "-" + QString::number(j), FID_None);
      }
    }
  }

  for (int i = 0; i < MAX_AVAILABLE_KEYS; ++i) {
    if (KeyAssign[crntset][i][0] == key) {
      return (FuncID)KeyAssign[crntset][i][(int)stat];
    }
  }
  
  if (key & ~(0xff | Qt::SHIFT)) {
    return FID_None;
  }
  
  return FID_InsertChar;
}


void KeyAssigner::accept()
{
  DEBUG_TRACEFUNC();
  saveSetting();
  QDialog::accept();
}


void KeyAssigner::reject()
{
  DEBUG_TRACEFUNC();
  QDialog::reject();
  loadSetting(ST_CURRENT_SETTING);
}


void KeyAssigner::saveDefaultSetting()
{
  DEBUG_TRACEFUNC();
  const int setting = ST_MSIME;
  for (int row = 0; row < MAX_AVAILABLE_KEYS; ++row) {
    if ( KeyAssign[setting][row][0] ) {
      for (int col = 0; col <= NUM_OF_CONVSTATUS; ++col) {
	Config::writeEntry(PREFIX + QString::number(row) + "-" + QString::number(col), KeyAssign[setting][row][col], FALSE);
      }

    } else {
      for (int col = 0; col <= NUM_OF_CONVSTATUS; ++col) {
	Config::writeEntry(PREFIX + QString::number(row) + "-" + QString::number(col), (int)0, FALSE);
      }
    }
  }

  Config::writeEntry("_cmbloadsetting", setting, FALSE);
}


void KeyAssigner::setKeySequenceName(int row, const QKeySequence& keyseq)
{
  DEBUG_TRACEFUNC();
  QTableWidgetItem* item = new QTableWidgetItem();
  item->setData(Qt::UserRole, keyseq[0]);   // Sets the key sequence element
  
  if (keyseq == QKeySequence(Qt::Key_Henkan)) {
    item->setText("Henkan");
  } else {
    item->setText(keyseq.toString());
  }
  _ui._keyassigntbl->setItem(row, 0, item);
}
